/*
 * Decompiled with CFR 0.152.
 */
package ags.muse.gun;

import ags.muse.base.Rules;
import ags.muse.physics.WaveIntersect;
import ags.muse.recon.Enemy;
import ags.util.GFPerspective;
import ags.util.Range;
import ags.util.points.AbsolutePoint;
import robocode.Bullet;
import robocode.util.Utils;

public class SWave {
    public final Enemy target;
    public final double initDistance;
    private final AbsolutePoint origin;
    private final double speed;
    private final double power;
    private double radius;
    private Range hitrange;
    private Range newhitrange;
    private Range lasthitrange;
    private final GFPerspective gfPerspective;
    private Bullet bullet;
    private double aimGF;

    public SWave(Rules rules, AbsolutePoint origin, double power, double radius, Enemy target) {
        this.origin = (AbsolutePoint)origin.clone();
        this.power = power;
        this.speed = Math.max(11.0, rules.getBulletSpeed(power));
        this.radius = radius;
        this.gfPerspective = new GFPerspective(origin, target.getLocation(), target.getVelocity(), target.ext.getLateralOrientation(), this.speed);
        this.target = target;
        this.initDistance = target.getLocation().distance(origin);
    }

    public Range getHitRange() {
        return this.hitrange;
    }

    public Range getNewHitRange() {
        return this.newhitrange;
    }

    public Range getLastHitRange() {
        return this.lasthitrange;
    }

    public double getAngle(double guessfactor) {
        return this.gfPerspective.getAngle(guessfactor);
    }

    public double getGF(double angle) {
        return this.gfPerspective.getGuessFactor(angle);
    }

    public double getGF(double x, double y) {
        double angle = Utils.normalAbsoluteAngle((double)Math.atan2(x - this.origin.x, y - this.origin.y));
        return this.gfPerspective.getGuessFactor(angle);
    }

    public double getInitDistance() {
        return this.initDistance;
    }

    public AbsolutePoint getOrigin() {
        return this.origin;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getSpeed() {
        return this.speed;
    }

    public double getPower() {
        return this.power;
    }

    public Bullet getBullet() {
        return this.bullet;
    }

    public double getAimGF() {
        return this.aimGF;
    }

    public void setBullet(Bullet bullet) {
        this.bullet = bullet;
        this.aimGF = bullet != null ? this.getGF(bullet.getHeadingRadians()) : 0.0;
    }

    public boolean expired() {
        return this.newhitrange == null && this.hitrange != null;
    }

    public void move() {
        this.radius += this.speed;
    }

    public void checkHit(AbsolutePoint l) {
        this.lasthitrange = this.hitrange;
        Range angleRange = WaveIntersect.getHitRange(this.origin, this.radius, this.speed, this.gfPerspective.hotAngle, l);
        this.newhitrange = angleRange != null ? new Range(this.getGF(angleRange.getLower() + this.gfPerspective.hotAngle), this.getGF(angleRange.getUpper() + this.gfPerspective.hotAngle)) : null;
        if (this.hitrange == null) {
            this.hitrange = this.newhitrange;
        } else if (this.newhitrange != null) {
            this.hitrange = this.hitrange.grow(this.newhitrange);
        }
    }
}

