/*
 * Decompiled with CFR 0.152.
 */
package ags.muse.physics;

import ags.muse.base.Rules;
import ags.muse.physics.RobotSim;
import ags.util.points.AbsolutePoint;
import ags.util.points.RelativePoint;

public class PhysicsEngine {
    private static final int ROBOT_SIZE = 18;

    public static void simulateTick(Rules rules, RobotSim sim, double intendedVelocity, double intendedTurn, boolean doWallCollisions) {
        double acceleration = intendedVelocity - sim.velocity.magnitude;
        acceleration = sim.velocity.magnitude == 0.0 || Math.abs(acceleration) > Math.abs(sim.velocity.magnitude) && Math.signum(acceleration) == Math.signum(sim.velocity.magnitude) ? Math.max(Math.min(acceleration, rules.ACCELERATION), -rules.ACCELERATION) : Math.max(Math.min(acceleration, rules.DECELERATION), -rules.DECELERATION);
        double maxav = rules.getTurnRate(Math.abs(sim.velocity.magnitude));
        double angularvelocity = Math.max(Math.min(intendedTurn, maxav), -maxav);
        sim.velocity = (RelativePoint)sim.velocity.clone();
        sim.velocity.setDirectionMagnitude(sim.velocity.getDirection() + angularvelocity, Math.max(Math.min(sim.velocity.magnitude + acceleration, rules.MAX_VELOCITY), -rules.MAX_VELOCITY));
        sim.location = sim.location.addRelativePoint(sim.velocity);
        if (doWallCollisions) {
            PhysicsEngine.processWallCollision(rules, sim);
        }
    }

    public static void simulateTick(RobotSim sim, double intendedVelocity, double intendedTurn) {
        double acceleration = intendedVelocity - sim.velocity.magnitude;
        acceleration = sim.velocity.magnitude == 0.0 || Math.abs(acceleration) > Math.abs(sim.velocity.magnitude) && Math.signum(acceleration) == Math.signum(sim.velocity.magnitude) ? Math.max(Math.min(acceleration, 1.0), -1.0) : Math.max(Math.min(acceleration, 2.0), -2.0);
        double maxav = robocode.Rules.getTurnRateRadians((double)Math.abs(sim.velocity.magnitude));
        double angularvelocity = Math.max(Math.min(intendedTurn, maxav), -maxav);
        sim.velocity = (RelativePoint)sim.velocity.clone();
        sim.velocity.setDirectionMagnitude(sim.velocity.getDirection() + angularvelocity, Math.max(Math.min(sim.velocity.magnitude + acceleration, 8.0), -8.0));
        sim.location = sim.location.addRelativePoint(sim.velocity);
    }

    private static boolean processWallCollision(Rules rules, RobotSim sim) {
        boolean hitWall = false;
        double fixx = 0.0;
        double fixy = 0.0;
        AbsolutePoint location = sim.location;
        RelativePoint velocity = sim.velocity;
        if ((double)Math.round(location.getX()) > rules.BATTLEFIELD_WIDTH - 18.0) {
            hitWall = true;
            fixx = rules.BATTLEFIELD_WIDTH - 18.0 - location.getX();
        }
        if (Math.round(location.getX()) < 18L) {
            hitWall = true;
            fixx = 18.0 - location.getX();
        }
        if ((double)Math.round(location.getY()) > rules.BATTLEFIELD_HEIGHT - 18.0) {
            hitWall = true;
            fixy = rules.BATTLEFIELD_HEIGHT - 18.0 - location.getY();
        }
        if (Math.round(location.getY()) < 18L) {
            hitWall = true;
            fixy = 18.0 - location.getY();
        }
        double tanHeading = Math.tan(velocity.direction);
        double fixxtanHeading = fixx / tanHeading;
        double fixytanHeading = fixy * tanHeading;
        if (fixx == 0.0) {
            fixx = fixytanHeading;
        } else if (fixy == 0.0) {
            fixy = fixxtanHeading;
        } else if (Math.abs(fixxtanHeading) > Math.abs(fixy)) {
            fixy = fixxtanHeading;
        } else if (Math.abs(fixytanHeading) > Math.abs(fixx)) {
            fixx = fixytanHeading;
        }
        location.setLocation(location.x + fixx, location.y + fixy);
        if (hitWall) {
            velocity.setDirectionMagnitude(velocity.direction, 0.0);
        }
        sim.hitWallFlag = hitWall;
        return hitWall;
    }
}

