/*
 * Decompiled with CFR 0.152.
 */
package ags.muse.recon;

import ags.muse.base.Rules;
import ags.muse.recon.Enemy;
import ags.muse.recon.SelfStatus;
import ags.util.BotStorage;
import java.util.Collection;
import java.util.List;
import robocode.Event;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class EnemyList {
    private final BotStorage<Enemy> botList = new BotStorage<Enemy>(){
        private static final long serialVersionUID = 1L;

        @Override
        public Enemy newOb(String botName) {
            return new Enemy(EnemyList.this.rules, botName);
        }
    };
    private final SelfStatus status;
    private final Rules rules;

    public EnemyList(Rules rules, SelfStatus status) {
        this.rules = rules;
        this.status = status;
    }

    public void handleEvents(List<Event> events) {
        for (Event e : events) {
            if (e instanceof ScannedRobotEvent) {
                ScannedRobotEvent s = (ScannedRobotEvent)e;
                this.botList.getOb(s.getName());
            }
            if (!(e instanceof RobotDeathEvent)) continue;
            RobotDeathEvent d = (RobotDeathEvent)e;
            this.botList.remove(d.getName());
        }
        for (Enemy enemy : this.botList.values()) {
            enemy.handleEvents(events, this.status);
        }
    }

    public boolean contains(String name) {
        return this.botList.containsKey(name);
    }

    public Enemy getBot(String name) {
        return (Enemy)this.botList.get(name);
    }

    public Collection<Enemy> getBots() {
        return this.botList.values();
    }
}

