/*
 * Decompiled with CFR 0.152.
 */
package ags.util;

public final class StatMath {
    static final double a1 = 0.254829592;
    static final double a2 = -0.284496736;
    static final double a3 = 1.421413741;
    static final double a4 = -1.453152027;
    static final double a5 = 1.061405429;
    static final double p = 0.3275911;
    static final double sqrt2 = Math.sqrt(2.0);

    private StatMath() {
    }

    public static double phi(double x) {
        int sign = x < 0.0 ? -1 : 1;
        x = Math.abs(x) / sqrt2;
        double t = 1.0 / (1.0 + 0.3275911 * x);
        double y = 1.0 - ((((1.061405429 * t + -1.453152027) * t + 1.421413741) * t + -0.284496736) * t + 0.254829592) * t * Math.exp(-x * x);
        return 0.5 * (1.0 + (double)sign * y);
    }

    public static double phi(double x, double mu, double sigma) {
        return StatMath.phi((x - mu) / sigma);
    }
}

