/*
 * Decompiled with CFR 0.152.
 */
package rz.a;

import java.util.ArrayList;
import rz.a.Point;

public class Store {
    public double posX;
    public double posY;
    private byte[] samplesX;
    private byte[] samplesY;
    private byte distToMe;
    private byte distToWall;
    private byte distToCorner;
    private double acceleration;
    public double heading;
    public double velocity;
    public boolean goodEnough;

    private static final byte limitByte(double value) {
        return (byte)Math.round(Math.max(-128.0, Math.min(10.0 * value, 127.0)));
    }

    public int evalPat(Store st, int deepIndex) {
        if (this.goodEnough && Math.abs(this.velocity - st.velocity) < 2.1 && Math.abs(this.acceleration - st.acceleration) < 0.9) {
            int d1 = this.distToCorner - st.distToCorner;
            int d2 = this.distToWall - st.distToWall;
            int d3 = this.distToMe - st.distToMe;
            int v = d1 * d1 + d2 * d2 + d3 * d3;
            int j = deepIndex - 1;
            while (j >= 0) {
                int dX = this.samplesX[j] - st.samplesX[j];
                int dY = this.samplesY[j] - st.samplesY[j];
                v += dX * dX + dY * dY;
                --j;
            }
            return v;
        }
        return 100000;
    }

    public Store(ArrayList pat, int[] sampleChoice, Point ePos, double d1, double d2, double d3, boolean good, boolean acc) {
        this.posX = ePos.x;
        this.posY = ePos.y;
        this.distToMe = Store.limitByte(d1 / 100.0);
        this.distToWall = Store.limitByte(d2 / 140.0);
        this.distToCorner = Store.limitByte(d3 / 200.0);
        this.goodEnough = good;
        try {
            Point[] samples = new Point[sampleChoice.length];
            int endIndex = pat.size();
            int i = 0;
            while (i < sampleChoice.length) {
                Store last = (Store)pat.get(endIndex - sampleChoice[i]);
                samples[i] = new Point((this.posX - last.posX) / Math.pow(sampleChoice[i], 0.925), (this.posY - last.posY) / Math.pow(sampleChoice[i], 0.925));
                ++i;
            }
            this.heading = samples[0].getAngle();
            this.velocity = Math.min(samples[0].getLength(), 8.0);
            this.acceleration = (double)acc * Math.max(-2.0, Math.min(this.velocity - ((Store)pat.get((int)(endIndex - 1))).velocity, (double)2));
            this.samplesX = new byte[sampleChoice.length];
            this.samplesY = new byte[sampleChoice.length];
            i = 0;
            while (i < samples.length) {
                samples[i].rotate(-this.heading);
                this.samplesX[i] = Store.limitByte(samples[i].x);
                this.samplesY[i] = Store.limitByte(samples[i].y);
                ++i;
            }
        }
        catch (Exception e) {
            this.goodEnough = false;
        }
    }
}

