/*
 * Decompiled with CFR 0.152.
 */
package catcat20.jewel.iolite.gun;

import catcat20.jewel.iolite.gun.Gun;
import catcat20.jewel.iolite.gun.NNGun;
import catcat20.jewel.iolite.gun.WaveGun;
import catcat20.jewel.iolite.gun.gf.AntiSurferGun;
import catcat20.jewel.iolite.gun.gf.GuessFactorGun;
import catcat20.jewel.iolite.gun.gf.SimpleGFGun;
import catcat20.jewel.iolite.gun.pif.PlayItForward;
import catcat20.jewel.iolite.radar.IoliteRadar;
import catcat20.jewel.iolite.utils.BotState;
import catcat20.jewel.iolite.utils.IUtils;
import catcat20.jewel.iolite.utils.Wave;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.TeamRobot;
import robocode.util.Utils;

public class IoliteGun {
    public static double allHitDamage = 0.0;
    public TeamRobot robot;
    public static ArrayList<Bullet> realBullets;
    public ArrayList<Wave> waves;
    public static ArrayList<Gun> guns;
    public static ArrayList<WaveGun> waveGuns;
    public static double duelFireCount;
    public static double duelHitCount;
    PlayItForward meleeGun;
    public double meleeGunFireCount = 1.0;
    public double meleeGunHitCount = 0.0;
    double actualFireCount = 6.0;
    double bulletHitBulletCount = 0.0;
    public static NNGun nnGun;
    public static PlayItForward pifGun;
    public Gun lastBestGun = null;
    public ArrayList<VBullet> vBullets;
    Point2D.Double myPos;
    public static final double MAX_BOT_HALF_WIDTH;
    Wave lastFireWave = null;
    Wave lastHitWave = null;
    double currentGF = 0.0;

    public IoliteGun(TeamRobot robot) {
        this.robot = robot;
        realBullets = new ArrayList();
        this.meleeGun = new PlayItForward(robot);
        this.meleeGun.isMelee = true;
        this.waves = new ArrayList();
        this.vBullets = new ArrayList();
        if (guns == null) {
            guns = new ArrayList();
            waveGuns = new ArrayList();
            GuessFactorGun gfGun = new GuessFactorGun(robot);
            guns.add(gfGun);
            waveGuns.add(gfGun);
            AntiSurferGun antiSurferGun = new AntiSurferGun(robot);
            guns.add(antiSurferGun);
            waveGuns.add(antiSurferGun);
            SimpleGFGun simpleGFGun = new SimpleGFGun(robot);
            guns.add(simpleGFGun);
            waveGuns.add(simpleGFGun);
            pifGun = new PlayItForward(robot);
            guns.add(pifGun);
        }
        IoliteGun.pifGun.poss.clear();
        IoliteGun.pifGun.possPass.clear();
        IoliteGun.pifGun.possDistance.clear();
        IoliteGun.pifGun.possPassDistance.clear();
        for (Gun gun : guns) {
            gun.init();
        }
        this.meleeGun.init();
    }

    public void execute() {
        this.myPos = new Point2D.Double(this.robot.getX(), this.robot.getY());
        double gunHeat = this.robot.getGunHeat();
        long time = this.robot.getTime();
        if (this.robot.getOthers() <= 1) {
            for (BotState en : IoliteRadar.enemies.values()) {
                if (!en.alive) continue;
                Wave w = new Wave();
                w.enemyData = (BotState)en.clone();
                w.myData = (BotState)en.myState.clone();
                w.bulletPower = IoliteRadar.calculatePower();
                w.isMeleeWave = false;
                w.direction = IUtils.sign(en.latVel);
                w.directAngle = en.absBearing;
                w.fireTime = time;
                w.isRealWave = gunHeat == 0.0;
                w.x = this.robot.getX();
                w.y = this.robot.getY();
                this.waves.add(w);
                this.lastFireWave = w;
            }
        }
        double power = IoliteRadar.calculatePower();
        if (this.robot.getOthers() > 1) {
            this.meleeGun.execute();
            if (this.robot.getEnergy() > power + 0.1 && this.robot.getGunHeat() == 0.0 && this.robot.getGunTurnRemaining() <= 1.0) {
                Bullet bullet = this.robot.setFireBullet(power);
                this.meleeGunFireCount += 1.0;
                if (bullet != null) {
                    realBullets.add(bullet);
                }
            }
            this.robot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this.meleeGun.getOffset() - this.robot.getGunHeadingRadians())));
        } else {
            BotState enemy = IoliteRadar.getNearestEnemy();
            if (enemy != null) {
                double bestAngle = 0.0;
                double bestHit = Double.NEGATIVE_INFINITY;
                Gun bestGun = null;
                for (Gun gun : guns) {
                    gun.execute();
                    double angle = gun.getOffset();
                    if (this.robot.getGunHeat() == 0.0 && this.robot.getEnergy() > power + 0.05 && this.robot.getOthers() >= 1) {
                        VBullet vBullet = new VBullet();
                        vBullet.firePos = (Point2D.Double)this.myPos.clone();
                        vBullet.fireTime = time;
                        vBullet.angle = angle;
                        vBullet.power = power;
                        vBullet.fireGun = gun;
                        this.vBullets.add(vBullet);
                        enemy.gunHitRate.get((Object)gun).shotCount += 1.0;
                    }
                    if (!(bestHit < enemy.gunHitRate.get((Object)gun).hitCount)) continue;
                    bestGun = gun;
                    bestHit = enemy.gunHitRate.get((Object)gun).hitCount;
                    bestAngle = angle;
                }
                for (WaveGun waveGun : waveGuns) {
                    waveGun.update(this.lastFireWave);
                }
                if (bestGun != null) {
                    if (this.robot.getGunHeat() / this.robot.getGunCoolingRate() < 3.01) {
                        Bullet bullet;
                        double noise = Math.random() / 10000.0 - 5.0E-5;
                        if (this.bulletHitBulletCount / this.actualFireCount * 100.0 >= 40.0) {
                            noise = Math.random() / 1000.0 - 5.0E-4;
                            System.out.println("[a]my bullets are shielded!  " + this.bulletHitBulletCount / this.actualFireCount * 100.0 + "%");
                        }
                        if (this.bulletHitBulletCount / this.actualFireCount * 100.0 >= 55.0) {
                            noise = Math.random() / 100.0 - 0.005;
                            System.out.println("[e]my bullets are shielded!!!!!  " + this.bulletHitBulletCount / this.actualFireCount * 100.0 + "%");
                        }
                        this.robot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(bestAngle - this.robot.getGunHeadingRadians() + noise)));
                        if (this.robot.getEnergy() > power + 0.1 && this.robot.getGunHeat() == 0.0 && this.robot.getGunTurnRemaining() <= 5.0 && (bullet = this.robot.setFireBullet(power)) != null && this.robot.getOthers() <= 1) {
                            this.actualFireCount += 1.0;
                            duelFireCount += 1.0;
                            realBullets.add(bullet);
                        }
                    }
                    if (this.lastBestGun != bestGun) {
                        System.out.println("Switching to " + bestGun.getLabel() + "Gun.    (" + 100.0 * enemy.gunHitRate.get((Object)bestGun).hitCount / enemy.gunHitRate.get((Object)bestGun).shotCount + "%)");
                    }
                    this.lastBestGun = bestGun;
                }
            }
            this.updateVBullets();
            this.updateWaves();
            this.updateRealBullets();
        }
    }

    public void updateRealBullets() {
        for (int i = 0; i < realBullets.size(); ++i) {
            Bullet bullet = realBullets.get(i);
            if (bullet.isActive()) continue;
            realBullets.remove(i);
            --i;
        }
    }

    public void updateVBullets() {
        Graphics2D g = this.robot.getGraphics();
        long time = this.robot.getTime();
        for (int i = 0; i < this.vBullets.size(); ++i) {
            VBullet vBullet = this.vBullets.get(i);
            Point2D.Double pos = IUtils.project(vBullet.firePos, vBullet.angle, (double)(time - vBullet.fireTime) * vBullet.bulletVelocity());
            g.setColor(vBullet.fireGun.getColor());
            g.fillOval((int)pos.x - 2, (int)pos.y - 2, 4, 4);
            for (BotState en : IoliteRadar.enemies.values()) {
                if (!en.alive || !(en.distance(pos) <= 18.0)) continue;
                en.gunHitRate.get((Object)vBullet.fireGun).hitCount += 1.0;
                this.vBullets.remove(i);
                --i;
            }
        }
    }

    public void updateWaves() {
        long time = this.robot.getTime();
        for (int x = 0; x < this.waves.size(); ++x) {
            Wave ew = this.waves.get(x);
            BotState en = IoliteRadar.getEnemy(ew.enemyData.name);
            IoliteRadar.getEnemy((String)ew.enemyData.name).currentGF = this.currentGF = ew.guessAngle(en);
            ew.distanceTraveled = ((double)time - ew.fireTime) * ew.bulletVelocity();
            if (!(ew.distanceTraveled > this.myPos.distance(en) + MAX_BOT_HALF_WIDTH)) continue;
            for (WaveGun gun : waveGuns) {
                gun.logHit(ew, en);
            }
            this.lastHitWave = ew;
            this.waves.remove(x);
            --x;
        }
    }

    public void onRoundEnded(RoundEndedEvent e) {
        for (Gun gun : guns) {
            gun.onRoundEnded(e);
        }
        System.out.println();
        System.out.println("*****Gun HitRate*****");
        System.out.println();
        for (BotState enemy : IoliteRadar.enemies.values()) {
            for (Gun gun : guns) {
                double hitRate = enemy.gunHitRate.get((Object)gun).hitCount / enemy.gunHitRate.get((Object)gun).shotCount;
                System.out.println("[" + enemy.name + "] " + gun.getLabel() + "Gun hitRate: " + (hitRate *= 100.0) + "% , usedTime: " + (double)gun.useTime / (double)gun.callCount);
            }
        }
        System.out.println();
        System.out.println("Melee Gun hitRate: " + 100.0 * this.meleeGunHitCount / this.meleeGunFireCount + "%");
        System.out.println("Actual 1v1 Gun hitRate: " + IoliteGun.getRealHitRate() + "%");
        if (this.robot.getOthers() > 1) {
            this.meleeGun.onRoundEnded(e);
        }
    }

    public static double getRealHitRate() {
        return 100.0 * (duelHitCount / duelFireCount);
    }

    public static double getHighestHitRate() {
        double bestRate = Double.NEGATIVE_INFINITY;
        Object bestGun = null;
        BotState enemy = IoliteRadar.getNearestEnemy();
        if (enemy != null) {
            for (Gun gun : guns) {
                double hitRate = enemy.gunHitRate.get((Object)gun).hitCount / enemy.gunHitRate.get((Object)gun).shotCount;
                if (!(bestRate < (hitRate *= 100.0))) continue;
                bestRate = hitRate;
            }
        } else {
            return 0.0;
        }
        return bestRate;
    }

    public void onBulletHit(BulletHitEvent e) {
        allHitDamage += Rules.getBulletDamage((double)e.getBullet().getPower());
        BotState en = IoliteRadar.getNearestEnemy();
        Point2D.Double hitLocation = new Point2D.Double(en.x, en.y);
        Wave nearestWave = this.nearestWave(hitLocation);
        if (this.robot.getOthers() > 1) {
            this.meleeGunHitCount += 1.0;
            this.meleeGun.onBulletHit(nearestWave, e);
        } else {
            for (Gun gun : guns) {
                gun.onBulletHit(nearestWave, e);
            }
            duelHitCount += 1.0;
        }
    }

    public Wave nearestWave(Point2D.Double hitLocation) {
        Wave nearestWave = null;
        double bestDist = Double.POSITIVE_INFINITY;
        for (Wave w : this.waves) {
            double dist = w.distance(hitLocation) - w.distanceTraveled;
            if (!(bestDist > dist)) continue;
            bestDist = dist;
            nearestWave = w;
        }
        return nearestWave;
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        BotState en = IoliteRadar.getNearestEnemy();
        Point2D.Double hitLocation = new Point2D.Double(en.x, en.y);
        Wave nearestWave = this.nearestWave(hitLocation);
        if (this.robot.getOthers() > 1) {
            this.meleeGun.onBulletHitBullet(nearestWave, e);
        } else {
            this.bulletHitBulletCount += 1.0;
            System.out.println("shield?  " + this.bulletHitBulletCount / this.actualFireCount * 100.0 + "%");
            for (Gun gun : guns) {
                gun.onBulletHitBullet(nearestWave, e);
            }
        }
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.white);
        g.drawString("power:" + IoliteRadar.calculatePower(), (int)this.robot.getX() - 30, (int)this.robot.getY() - 60);
        for (Gun gun : guns) {
            gun.onPaint(g);
        }
        if (this.robot.getOthers() > 1) {
            this.meleeGun.onPaint(g);
        }
    }

    static {
        duelFireCount = 1.0;
        duelHitCount = 0.0;
        MAX_BOT_HALF_WIDTH = Math.sqrt(2.0) * 18.001;
    }

    public class VBullet {
        public Gun fireGun;
        public Point2D.Double firePos;
        public double angle;
        public double power;
        public long fireTime;

        public double bulletVelocity() {
            return Rules.getBulletSpeed((double)this.power);
        }
    }
}

