/*
 * Decompiled with CFR 0.152.
 */
package voidious.utils;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import voidious.utils.DiaUtils;

public class RobotState {
    public Point2D.Double location;
    public double heading;
    public double velocity;
    public long time;
    public boolean smoothing;
    protected Rectangle2D.Double _botRect = null;
    protected ArrayList<Line2D.Double> _botSides = null;

    public RobotState(Point2D.Double botLocation, double botHeadingRadians, double botVelocity) {
        this.location = botLocation;
        this.heading = botHeadingRadians;
        this.velocity = botVelocity;
        this.smoothing = false;
    }

    public RobotState(Point2D.Double botLocation, double botHeadingRadians, double botVelocity, long currentTime) {
        this(botLocation, botHeadingRadians, botVelocity);
        this.time = currentTime;
    }

    public RobotState(Point2D.Double botLocation, double botHeadingRadians, double botVelocity, long currentTime, boolean smooth) {
        this(botLocation, botHeadingRadians, botVelocity, currentTime);
        this.smoothing = smooth;
    }

    public Rectangle2D.Double botRect() {
        if (this._botRect == null) {
            this._botRect = DiaUtils.botRect(this.location);
        }
        return this._botRect;
    }

    public ArrayList<Line2D.Double> botSides() {
        if (this._botSides == null) {
            this._botSides = DiaUtils.botSides(this.location);
        }
        return this._botSides;
    }

    public Object clone() {
        return new RobotState((Point2D.Double)this.location.clone(), this.heading, this.velocity, this.time, this.smoothing);
    }
}

