/*
 * Decompiled with CFR 0.152.
 */
package wcsv.PowerHouse.Utilities;

import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.ListIterator;
import wcsv.PowerHouse.Utilities.Target;
import wcsv.PowerHouse.Utilities.Utilities;

public class Wave {
    public Target targetRobot;
    public Target sourceRobot;
    public double radius;
    public double velocity;
    public boolean isRealBullet;

    public Wave cloneWave() {
        Wave w = new Wave();
        w.targetRobot = this.targetRobot.cloneTarget();
        w.sourceRobot = this.sourceRobot.cloneTarget();
        w.velocity = this.velocity;
        w.radius = this.radius;
        w.isRealBullet = this.isRealBullet;
        return w;
    }

    public void advance() {
        this.radius += this.velocity;
    }

    public void advance(int ticks) {
        this.radius += this.velocity * (double)ticks;
    }

    public double distanceToPoint(Point2D.Double loc) {
        return Utilities.distance(loc, this.sourceRobot.location) - this.radius;
    }

    public int timeToPoint(Point2D.Double loc) {
        return (int)(this.distanceToPoint(loc) / this.velocity);
    }

    public double computeCentralBearingChange(Point2D.Double newLocation) {
        return Utilities.relativeAngle(Utilities.absoluteAngleToPoint(this.sourceRobot.location, newLocation) - Utilities.absoluteAngleToPoint(this.sourceRobot.location, this.targetRobot.location));
    }

    public double absoluteBearingFromSource(Point2D.Double newLocation) {
        return Utilities.absoluteAngleToPoint(this.sourceRobot.location, newLocation);
    }

    public static Wave getClosestWave(Point2D.Double loc, LinkedList waves) {
        ListIterator it = waves.listIterator();
        double closestDist = Double.MAX_VALUE;
        Wave w = null;
        Wave closest = null;
        while (it.hasNext()) {
            w = (Wave)it.next();
            double currDist = Math.abs(w.distanceToPoint(loc));
            if (!(currDist < closestDist)) continue;
            closest = w;
            closestDist = currDist;
        }
        return closest;
    }

    public Wave() {
    }

    public Wave(Target src, Target targ, double bulletPower, int radiusOffset, boolean real) {
        this.targetRobot = targ.cloneTarget();
        this.sourceRobot = src.cloneTarget();
        this.velocity = Utilities.bulletPowerToVelocity(bulletPower);
        this.radius = this.velocity * (double)radiusOffset;
        this.isRealBullet = real;
    }
}

