/*
 * Decompiled with CFR 0.152.
 */
package techdude.forest;

import techdude.forest.Coordinate;
import techdude.forest.FlamingForest;
import techdude.forest.Pattern;
import techdude.forest.TechDudeMath;
import techdude.forest.TechDudeRecord;
import techdude.forest.TechDudeRecordCollection;

class DefaultPattern
implements Pattern {
    public boolean test(TechDudeRecord[] in_strand) {
        return true;
    }

    public Coordinate estimatePosition(double in_x, double in_y, double in_velocity, double in_time, double in_heading, TechDudeRecordCollection in_collection) {
        double secondAngle = in_collection.get(0).getAngle();
        double firstAngle = in_collection.get(1).getAngle();
        double angleChange = TechDudeMath.normalRelativeAngle(secondAngle - firstAngle) / (double)(in_collection.get(0).getTime() - in_collection.get(1).getTime());
        double acceleration = in_collection.get(0).getVelocity() - in_collection.get(1).getVelocity();
        acceleration = acceleration > 0.0 ? 1 : (acceleration == 0.0 ? 0 : -2);
        Coordinate currentPosition = new Coordinate(in_x, in_y);
        int roundTime = Math.round((float)in_time);
        int iCounter = 0;
        while (iCounter < roundTime) {
            in_heading = TechDudeMath.normalAbsoluteAngle(in_heading + angleChange);
            currentPosition.setX(currentPosition.getX() + Math.sin(in_heading) * in_velocity);
            currentPosition.setY(currentPosition.getY() + Math.cos(in_heading) * in_velocity);
            if (currentPosition.getX() > FlamingForest.FIELD_WIDTH || currentPosition.getX() < 0.0 || currentPosition.getY() > FlamingForest.FIELD_HEIGHT || currentPosition.getY() < 0.0) {
                currentPosition.setX(currentPosition.getX() - Math.sin(in_heading) * in_velocity * (double)2);
                currentPosition.setY(currentPosition.getY() - Math.cos(in_heading) * in_velocity * (double)2);
                return currentPosition;
            }
            ++iCounter;
        }
        in_heading = TechDudeMath.normalAbsoluteAngle(in_heading + angleChange * (in_time - (double)roundTime));
        currentPosition.setX(currentPosition.getX() + Math.sin(in_heading) * (in_velocity * (in_time - (double)roundTime)));
        currentPosition.setY(currentPosition.getY() + Math.cos(in_heading) * (in_velocity * (in_time - (double)roundTime)));
        return currentPosition;
    }

    DefaultPattern() {
    }
}

