/*
 * Decompiled with CFR 0.152.
 */
package bwbaugh.nano;

import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Tirunculus
extends AdvancedRobot {
    int turnDirection = 1;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
            this.scan();
        }
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        double radarTurn = this.getHeadingRadians() + event.getBearingRadians() - this.getRadarHeadingRadians();
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(2.0 * radarTurn)));
        double absoluteBearing = this.getHeadingRadians() + event.getBearingRadians();
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absoluteBearing - this.getGunHeadingRadians() + event.getVelocity() * Math.sin(event.getHeadingRadians() - absoluteBearing) / 13.0)));
        if (event.getDistance() < 68.0) {
            this.setFire(3.0);
        } else if (event.getDistance() < 128.0) {
            this.setFire(1.5);
        }
        this.turnDirection = event.getBearing() >= 0.0 ? 1 : -1;
        this.setTurnRight(event.getBearing());
        this.setAhead(event.getDistance() + 5.0);
        if (event.getBearing() >= 20.0 || event.getBearing() <= -20.0) {
            this.setMaxVelocity(0.0);
        } else {
            this.setMaxVelocity(8.0);
        }
    }

    private double limit(double value, double min, double max) {
        return Math.min(max, Math.max(min, value));
    }

    public void onHitByBullet(HitByBulletEvent e) {
    }
}

