/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws;

import java.awt.geom.Point2D;
import xander.core.math.RCMath;
import xander.core.track.Wave;

public class BasicFactorArrays {
    public static double getFactorAngle(Wave bulletWave, double defenderX, double defenderY) {
        double zeroAngle = RCMath.getRobocodeAngle(bulletWave.getOrigin(), bulletWave.getInitialDefenderSnapshot().getLocation());
        double currentAngle = RCMath.getRobocodeAngle(bulletWave.getOriginX(), bulletWave.getOriginY(), defenderX, defenderY);
        return RCMath.getTurnAngle(zeroAngle, currentAngle);
    }

    public static double getFactorAngle(Wave bulletWave, Point2D.Double currentDefenderLocation) {
        double zeroAngle = RCMath.getRobocodeAngle(bulletWave.getOrigin(), bulletWave.getInitialDefenderSnapshot().getLocation());
        double currentAngle = RCMath.getRobocodeAngle(bulletWave.getOrigin(), currentDefenderLocation);
        return RCMath.getTurnAngle(zeroAngle, currentAngle);
    }

    public static double getFactorAngle(Wave bulletWave, double robocodeAngleDegrees) {
        double zeroAngle = RCMath.getRobocodeAngle(bulletWave.getOrigin(), bulletWave.getInitialDefenderSnapshot().getLocation());
        return RCMath.getTurnAngle(zeroAngle, robocodeAngleDegrees);
    }

    public static int getFactorIndex(double preciseFactorIndex) {
        return (int)Math.round(Math.floor(preciseFactorIndex));
    }

    public static double getEstimatedFactorIndexRobotWidth(int numFactors, double distance, double bulletVelocity) {
        double circ = Math.PI * 2 * distance;
        double bodyWidthDegrees = 14400.0 / circ;
        double mea = RCMath.getMaximumEscapeAngle(bulletVelocity);
        double rbfactor = bodyWidthDegrees / mea;
        return RCMath.limit((double)numFactors / 2.0 + rbfactor * (double)numFactors / 2.0, 0.0, (double)numFactors - 0.001) - (double)numFactors / 2.0;
    }

    public static int getMostWeightedFactorIndex(double[] array, int beginFactorIndex, int endFactorIndex) {
        int bestFactorIndex = -1;
        double bestFactorValue = Double.NEGATIVE_INFINITY;
        int tieCount = 0;
        boolean runningTie = false;
        int i = beginFactorIndex;
        while (i <= endFactorIndex) {
            if (array[i] > bestFactorValue) {
                bestFactorValue = array[i];
                bestFactorIndex = i;
                tieCount = 0;
                runningTie = true;
            } else if (runningTie && array[i] == bestFactorValue) {
                ++tieCount;
            } else {
                runningTie = false;
            }
            ++i;
        }
        return bestFactorIndex + tieCount / 2;
    }

    public static double getDistanceDangerMultiplier(double distance, double flatDistance, double criticalDistance) {
        return distance < flatDistance ? Math.pow((flatDistance - criticalDistance) / (Math.max(distance, criticalDistance + 0.1) - criticalDistance), 2.0) : 1.0;
    }
}

