/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws.drive;

import java.awt.geom.Path2D;
import java.util.Arrays;
import robocode.Bullet;
import robocode.HitByBulletEvent;
import xander.core.Resources;
import xander.core.RobotProxy;
import xander.core.drive.DirectDrivePredictor;
import xander.core.drive.Drive;
import xander.core.drive.DriveController;
import xander.core.drive.DriveState;
import xander.core.event.OpponentWaveListener;
import xander.core.math.RCMath;
import xander.core.math.RCPhysics;
import xander.core.track.Snapshot;
import xander.core.track.SnapshotHistory;
import xander.core.track.Wave;
import xander.gfws.drive.DirectSurfSelection;
import xander.gfws.drive.DirectSurfSelector;
import xander.paint.Paintable;
import xander.paint.Paintables;

public class DirectWaveSurfingDrive
implements Drive,
OpponentWaveListener,
Paintable {
    private String driveName;
    private RobotProxy robotProxy;
    private SnapshotHistory snapshotHistory;
    private DirectDrivePredictor predictor;
    private boolean surfMultipleWaves;
    private int wave1SurfOptions = 4;
    private Wave surfWave;
    private Wave lastSurfWave;
    private boolean surfWaveUpdated;
    private double oppSurfX;
    private double oppSurfY;
    private double[] oppSurfXYShift;
    private DirectSurfSelection[] wave1SurfSelections = new DirectSurfSelection[1];
    private DirectSurfSelection[] wave2SurfSelections = null;
    private DirectSurfSelector surfSelector;
    private double cTargetHeading;
    private double cTargetFactorAngle;
    private int[] optionCounts;
    private String painterName;

    public DirectWaveSurfingDrive(String driveName, DirectSurfSelector surfSelector, Path2D.Double driveBounds) {
        this.driveName = driveName;
        this.robotProxy = Resources.getRobotProxy();
        this.snapshotHistory = Resources.getSnapshotHistory();
        this.surfSelector = surfSelector;
        this.predictor = new DirectDrivePredictor(this.robotProxy.getBattleFieldSize(), driveBounds);
        this.wave1SurfSelections[0] = new DirectSurfSelection();
        Resources.getWaveHistory().addOpponentWaveListener(this);
    }

    public double getCTargetHeading() {
        return this.cTargetHeading;
    }

    public double getCTargetFactorAngle() {
        return this.cTargetFactorAngle;
    }

    public Wave getCSurfWave() {
        return this.surfWave;
    }

    public DirectDrivePredictor getCDirectDrivePredictor() {
        return this.predictor;
    }

    @Override
    public String getName() {
        return this.driveName;
    }

    @Override
    public String getPainterName() {
        return this.painterName;
    }

    public void setPainterName(String painterName) {
        this.painterName = painterName;
        Paintables.addPaintable(this);
    }

    public boolean isSurfMultipleWaves() {
        return this.surfMultipleWaves;
    }

    public void setSurfMultipleWaves(boolean surfMultipleWaves, int wave1SurfOptions) {
        this.surfMultipleWaves = surfMultipleWaves;
        this.wave1SurfOptions = wave1SurfOptions;
        if (surfMultipleWaves) {
            this.wave1SurfSelections = new DirectSurfSelection[wave1SurfOptions];
            int i = 0;
            while (i < wave1SurfOptions) {
                this.wave1SurfSelections[i] = new DirectSurfSelection();
                ++i;
            }
            this.wave2SurfSelections = new DirectSurfSelection[1];
            this.wave2SurfSelections[0] = new DirectSurfSelection();
            this.optionCounts = new int[wave1SurfOptions];
        } else {
            this.wave1SurfSelections = new DirectSurfSelection[1];
            this.wave1SurfSelections[0] = new DirectSurfSelection();
            this.wave2SurfSelections = null;
            this.optionCounts = null;
        }
    }

    public void setSurfMultipleWaves(boolean surfMultipleWaves) {
        this.setSurfMultipleWaves(surfMultipleWaves, this.wave1SurfOptions);
    }

    @Override
    public void onRoundBegin() {
        this.surfWave = null;
        this.lastSurfWave = null;
    }

    @Override
    public void drive(DriveController driveController) {
        if (this.robotProxy.getOthers() <= 0 && Resources.getWaveHistory().getOpponentActiveWaveCount() > 0 && this.surfWave != null) {
            Snapshot rs = this.snapshotHistory.getSnapshot(this.surfWave.getInitialAttackerSnapshot().getName());
            double distance = RCMath.getDistanceBetweenPoints(rs.getX(), rs.getY(), this.robotProxy.getX(), this.robotProxy.getY());
            Snapshot fakeRS = new Snapshot(rs.getName(), rs.getX(), rs.getY(), rs.getHeadingRoboRadians(), 0.0, distance, rs.getEnergy(), this.robotProxy.getTime());
            this.driveTo(fakeRS, driveController);
        }
    }

    @Override
    public void driveTo(Snapshot opponentSnapshot, DriveController driveController) {
        long time = this.robotProxy.getTime();
        Snapshot mySnapshot = this.snapshotHistory.getMySnapshot(time, true);
        DriveState myDriveState = new DriveState(mySnapshot);
        double oppDistDiff = 0.0;
        if (this.oppSurfXYShift != null && this.surfWave != null) {
            this.oppSurfX += this.oppSurfXYShift[0];
            this.oppSurfY += this.oppSurfXYShift[1];
            oppDistDiff = RCMath.getDistanceBetweenPoints(this.oppSurfX, this.oppSurfY, opponentSnapshot.getX(), opponentSnapshot.getY());
        }
        if (this.surfWave != null && (this.surfWave != this.lastSurfWave || oppDistDiff > 40.0 || this.surfWaveUpdated)) {
            Wave secondWave;
            int i = 0;
            while (i < this.wave1SurfSelections.length) {
                this.wave1SurfSelections[i].clear();
                ++i;
            }
            this.surfSelector.updateSurfSelection(this.wave1SurfSelections, this.surfWave, this.predictor, myDriveState, opponentSnapshot, time);
            this.cTargetFactorAngle = this.wave1SurfSelections[0].getFactorAngle();
            this.cTargetHeading = this.wave1SurfSelections[0].getHeading();
            if (this.surfMultipleWaves && (secondWave = Resources.getWaveHistory().getOpponentWaveAfter(this.surfWave, this.robotProxy.getX(), this.robotProxy.getY())) != null) {
                Arrays.sort(this.wave1SurfSelections);
                int option = 0;
                double combinedDanger = 0.0;
                int bestOption = 0;
                double bestCombinedDanger = Double.MAX_VALUE;
                do {
                    if (!this.wave1SurfSelections[option].isSet()) continue;
                    long tuh = this.surfWave.getTimeUntilHit(this.wave1SurfSelections[option].getFinalDriveState().getX(), this.wave1SurfSelections[option].getFinalDriveState().getY(), time);
                    this.wave2SurfSelections[0].clear();
                    this.surfSelector.updateSurfSelection(this.wave2SurfSelections, secondWave, this.predictor, this.wave1SurfSelections[option].getFinalDriveState(), opponentSnapshot, time + tuh);
                    if (!this.wave2SurfSelections[0].isSet()) continue;
                    long wave2tuh = secondWave.getTimeUntilHit(this.wave2SurfSelections[0].getFinalDriveState().getX(), this.wave2SurfSelections[0].getFinalDriveState().getY(), time);
                    double wave1BulletDamage = RCPhysics.getBulletDamage(this.surfWave.getBulletPower());
                    double wave1Danger = this.wave1SurfSelections[option].getDanger() * (wave1BulletDamage / (double)tuh);
                    double wave2BulletDamage = RCPhysics.getBulletDamage(secondWave.getBulletPower());
                    double wave2Danger = this.wave2SurfSelections[0].getDanger() * (wave2BulletDamage / (double)wave2tuh);
                    combinedDanger = wave1Danger + wave2Danger;
                    if (!(combinedDanger < bestCombinedDanger)) continue;
                    bestCombinedDanger = combinedDanger;
                    bestOption = option;
                } while (++option < this.wave1SurfSelections.length && bestCombinedDanger > this.wave1SurfSelections[option].getDanger());
                this.cTargetFactorAngle = this.wave1SurfSelections[bestOption].getFactorAngle();
                this.cTargetHeading = this.wave1SurfSelections[bestOption].getHeading();
                int n = bestOption;
                this.optionCounts[n] = this.optionCounts[n] + 1;
            }
            this.oppSurfX = opponentSnapshot.getX();
            this.oppSurfY = opponentSnapshot.getY();
            this.oppSurfXYShift = opponentSnapshot.getXYShift();
            this.oppSurfXYShift[0] = this.oppSurfXYShift[0] / 2.0;
            this.oppSurfXYShift[1] = this.oppSurfXYShift[1] / 2.0;
            this.lastSurfWave = this.surfWave;
            this.surfWaveUpdated = false;
        }
        if (this.surfWave == null) {
            driveController.drive(this.robotProxy.getBackAsFrontHeadingDegrees(), 0.0);
        } else {
            double targetSpeed = 8.0;
            if (this.predictor.shouldStop(this.surfWave, this.cTargetFactorAngle, myDriveState, this.cTargetHeading, targetSpeed, time)) {
                targetSpeed = 0.0;
            }
            driveController.drive(this.cTargetHeading, targetSpeed);
        }
    }

    @Override
    public void oppWaveUpdated(Wave wave) {
        if (wave == this.surfWave) {
            this.surfWaveUpdated = true;
        }
    }

    @Override
    public void oppWaveCreated(Wave wave) {
    }

    @Override
    public void oppWaveHitBullet(Wave wave, Bullet oppBullet) {
        if (this.surfMultipleWaves) {
            this.surfWaveUpdated = true;
        }
    }

    @Override
    public void oppWaveHit(Wave wave) {
    }

    @Override
    public void oppNextWaveToHit(Wave wave) {
        this.surfWave = wave;
    }

    @Override
    public void oppBulletHit(Wave wave, HitByBulletEvent hitByBulletEvent) {
    }

    @Override
    public void oppWavePassing(Wave wave) {
    }

    @Override
    public void oppWavePassed(Wave wave) {
    }

    @Override
    public void oppWaveDestroyed(Wave wave) {
    }
}

