/*
 * Decompiled with CFR 0.152.
 */
package barontrozo;

import robocode.Rules;

public class PowerSelector {
    static int pos_ = 6;
    static double[] power_;
    static double[] factor_;
    static double[] costFactor_;
    static double[] damageFactor_;
    static double[] cureFactor_;
    static double[] hits_;
    static double[] fired_;
    static double totHits_;
    static double totFired_;
    static double[] enemyHits_;
    static double[] enemyFired_;
    static double enemyTotHits_;
    static double enemyTotFired_;
    static boolean first_;
    double actualEnemyDamageFactor_;
    double coolRate_;

    static {
        totHits_ = 0.0;
        totFired_ = 1.0;
        enemyTotHits_ = 0.0;
        enemyTotFired_ = 0.0;
        first_ = true;
    }

    public PowerSelector(double coolRate) {
        this.coolRate_ = coolRate;
        if (first_) {
            power_ = new double[]{0.5, 1.0, 1.5, 2.0, 2.5, 3.0};
            factor_ = new double[pos_];
            costFactor_ = new double[pos_];
            damageFactor_ = new double[pos_];
            cureFactor_ = new double[pos_];
            hits_ = new double[pos_];
            fired_ = new double[pos_];
            enemyHits_ = new double[pos_];
            enemyFired_ = new double[pos_];
            int i = 0;
            while (i < pos_) {
                PowerSelector.factor_[i] = this.GetFactor(power_[i]);
                PowerSelector.costFactor_[i] = this.GetCostFactor(power_[i]);
                PowerSelector.damageFactor_[i] = this.GetDamageFactor(power_[i]);
                PowerSelector.cureFactor_[i] = this.GetCureFactor(power_[i]);
                PowerSelector.hits_[i] = 0.0;
                PowerSelector.fired_[i] = 0.0;
                PowerSelector.hits_[i] = 0.0;
                PowerSelector.fired_[i] = 0.0;
                PowerSelector.enemyHits_[i] = 0.0;
                PowerSelector.enemyFired_[i] = 0.0;
                ++i;
            }
            first_ = false;
        }
        this.actualEnemyDamageFactor_ = 0.0;
    }

    public double GetMaxUseful(double enemyEnergy, double myEnergy) {
        double power = 0.1;
        if (enemyEnergy >= 16.0) {
            power = 3.0;
        } else if (enemyEnergy > 4.0) {
            power = (enemyEnergy + 2.0) / 6.0;
        } else if (enemyEnergy > 0.4) {
            power = enemyEnergy / 4.0;
        }
        power = Math.min(power, myEnergy / 5.0);
        if (power < 0.1) {
            power = 0.1;
        }
        return power;
    }

    public double GetBestPower() {
        double maxP = Double.NEGATIVE_INFINITY;
        int bestP = 0;
        double maxN = Double.POSITIVE_INFINITY;
        int bestN = 0;
        int i = 0;
        while (i < pos_) {
            double percent = (hits_[i] + 0.2 * totHits_) / (fired_[i] + 0.2 * totFired_);
            double d1 = this.GetDamageFactor(power_[i]) * percent;
            double d2 = this.GetCureFactor(power_[i]) * percent - this.GetCostFactor(power_[i]) - this.actualEnemyDamageFactor_;
            double cal = d1 / d2;
            if (d2 < 0.0) {
                if (cal < maxN) {
                    maxN = cal;
                    bestN = i;
                }
            } else if (cal > maxP) {
                maxP = cal;
                bestP = i;
            }
            ++i;
        }
        if (maxP > 0.0) {
            return power_[bestP];
        }
        return power_[bestN];
    }

    public void IncrementStats(double power, boolean hit) {
        double min = 3.0;
        int best = 0;
        int i = 0;
        while (i < pos_) {
            double cal = Math.abs(power_[i] - power);
            if (cal < min) {
                min = cal;
                best = i;
            }
            ++i;
        }
        if (hit) {
            int n = best;
            hits_[n] = hits_[n] + 1.0;
            totHits_ += 1.0;
        }
        int n = best;
        fired_[n] = fired_[n] + 1.0;
        totFired_ += 1.0;
    }

    public double GetEnemyMostUsedPower() {
        double max = 0.0;
        int best = 0;
        int i = 0;
        while (i < pos_) {
            if (enemyFired_[i] > max) {
                max = enemyFired_[i];
                best = i;
            }
            ++i;
        }
        return power_[best];
    }

    public void IncrementEnemyStats(double power, boolean hit) {
        double min = 3.0;
        int best = 0;
        int i = 0;
        while (i < pos_) {
            double cal = Math.abs(power_[i] - power);
            if (cal < min) {
                min = cal;
                best = i;
            }
            ++i;
        }
        if (hit) {
            int n = best;
            enemyHits_[n] = enemyHits_[n] + 1.0;
            enemyTotHits_ += 1.0;
        }
        int n = best;
        enemyFired_[n] = enemyFired_[n] + 1.0;
        enemyTotFired_ += 1.0;
        this.actualEnemyDamageFactor_ = 0.0;
        i = 0;
        while (i < pos_) {
            this.actualEnemyDamageFactor_ += this.GetDamageFactor(power_[i]) * enemyHits_[i];
            ++i;
        }
        this.actualEnemyDamageFactor_ /= enemyTotFired_;
    }

    public double GetFactor(double power) {
        double factor = (Rules.getBulletDamage((double)power) + Rules.getBulletHitBonus((double)power)) / Math.ceil(Rules.getGunHeat((double)power) / this.coolRate_);
        return factor;
    }

    public double GetCostFactor(double power) {
        double factor = power / Math.ceil(Rules.getGunHeat((double)power) / this.coolRate_);
        return factor;
    }

    public double GetDamageFactor(double power) {
        double factor = Rules.getBulletDamage((double)power) / Math.ceil(Rules.getGunHeat((double)power) / this.coolRate_);
        return factor;
    }

    public double GetCureFactor(double power) {
        double factor = Rules.getBulletHitBonus((double)power) / Math.ceil(Rules.getGunHeat((double)power) / this.coolRate_);
        return factor;
    }

    public void PrintFactor() {
        System.out.printf("----ME----\n", new Object[0]);
        int i = 0;
        while (i < pos_) {
            double percent = (hits_[i] + 0.2 * totHits_) / (fired_[i] + 0.2 * totFired_);
            double d1 = this.GetDamageFactor(power_[i]) * percent;
            double d2 = this.GetCureFactor(power_[i]) * percent - this.GetCostFactor(power_[i]) - this.actualEnemyDamageFactor_;
            double cal = d1 / d2;
            System.out.printf("%f power - %f/%f - %f pOne - [%f] total Factor   Used -> [%f - %f,%f,%f][%f]\n", power_[i], hits_[i], fired_[i], hits_[i] / fired_[i], factor_[i] * (hits_[i] / fired_[i]) - this.GetCostFactor(power_[i]), this.actualEnemyDamageFactor_, percent, d1, d2, cal);
            ++i;
        }
        System.out.printf("%f/%f - %f pOne\n", totHits_, totFired_, totHits_ / totFired_);
        System.out.printf("----ENEMY----\n", new Object[0]);
        i = 0;
        while (i < pos_) {
            System.out.printf("%f power - %f/%f - %f pOne - [%f] total Factor\n", power_[i], enemyHits_[i], enemyFired_[i], enemyHits_[i] / enemyFired_[i], factor_[i] * (enemyHits_[i] / enemyFired_[i]) - this.GetCostFactor(power_[i]));
            ++i;
        }
        System.out.printf("%f/%f - %f pOne\n", enemyTotHits_, enemyTotFired_, enemyTotHits_ / enemyTotFired_);
    }
}

