/*
 * Decompiled with CFR 0.152.
 */
package pedersen.opponent;

import java.awt.Graphics2D;
import java.util.Iterator;
import pedersen.core.Conversions;
import pedersen.misc.VaultBase;
import pedersen.opponent.Target;

public class TargetBank
extends VaultBase {
    public static final TargetBank singleton = new TargetBank();

    private TargetBank() {
    }

    public Target findByName(String name) {
        Target vaultEntryMatch = null;
        Iterator iterator = this.iterator();
        while (vaultEntryMatch == null && iterator.hasNext()) {
            Target vaultEntry = (Target)iterator.next();
            if (!vaultEntry.getName().equals(name)) continue;
            vaultEntryMatch = vaultEntry;
        }
        return vaultEntryMatch;
    }

    public void deactivateAllTargets() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ((Target)iterator.next()).deactivate();
        }
    }

    public void roundTearDown() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ((Target)iterator.next()).roundTearDown();
        }
    }

    public void teardown() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ((Target)iterator.next()).teardown();
        }
        this.vault.clear();
    }

    public void onDefensiveFire() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ((Target)iterator.next()).onDefensiveFire();
        }
    }

    public void onPaint(Graphics2D console) {
        Iterator targets = this.iterator();
        while (targets.hasNext()) {
            ((Target)targets.next()).onPaint(console);
        }
    }

    public void onRobotHitByCombatant(String name, double firepower) {
        Target target = this.findByName(name);
        if (target != null) {
            target.receiveBulletDamage(Conversions.getBulletDamageFromFirepower(firepower));
        }
    }

    public void onCombatantHitByRobot(String name, double firepower) {
        Target target = this.findByName(name);
        if (target != null) {
            target.dealBulletDamage(firepower);
        }
    }
}

