/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics;

import pedersen.core.Constraints;
import pedersen.debug.Debug;
import pedersen.physics.DynamicHeading;
import pedersen.physics.StaticHeading;
import pedersen.physics.StaticHeadingImpl;

public class DynamicHeadingImpl
implements DynamicHeading {
    private double heading;
    private double target;

    public DynamicHeadingImpl(double newHeading) {
        this.setHeading(newHeading);
        this.setAbsoluteTargetHeading(newHeading);
    }

    public DynamicHeadingImpl(StaticHeading newHeading) {
        this.setHeading(newHeading.getHeading());
        this.setAbsoluteTargetHeading(newHeading.getHeading());
    }

    public StaticHeading getStaticHeading() {
        return new StaticHeadingImpl(this.heading);
    }

    public void setHeading(double newHeading) {
        this.heading = newHeading;
    }

    public void setAbsoluteTargetHeading(double newHeading) {
        this.target = newHeading;
    }

    public void setRelativeTargetHeading(double other) {
        this.setAbsoluteTargetHeading(this.getCompoundAngle(other));
    }

    public double projectHeading(double maxTurnRate) {
        return this.getCompoundAngle(Constraints.getClosestLegalTurnRate(this.getRelativeAngle(this.target), maxTurnRate));
    }

    public void debug() {
        Debug.debug("Dynamic heading: " + Debug.trim(this.heading));
        Debug.debug("Target heading: " + Debug.trim(this.target));
    }

    public double getHeading() {
        return this.heading;
    }

    public boolean equalsAngle(double other) {
        return Constraints.areEqual(this.heading, other);
    }

    public double getRelativeAngle(double other) {
        return StaticHeadingImpl.getRelativeAngle(this.heading, other);
    }

    public double getCompoundAngle(double other) {
        return StaticHeadingImpl.getCompoundAngle(this.heading, other);
    }
}

