/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics;

import pedersen.core.Constraints;
import pedersen.debug.Debug;
import pedersen.physics.DynamicPositionImpl;
import pedersen.physics.StaticHeadingImpl;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;
import pedersen.physics.StaticVector;
import pedersen.physics.StaticVelocityImpl;

public class StaticVectorImpl
implements StaticVector {
    private final double heading;
    private final double velocity;

    public StaticVectorImpl(double newHeading, double newVelocity) {
        this.heading = newHeading;
        this.velocity = newVelocity;
    }

    public StaticVectorImpl(StaticVector other) {
        this.heading = other.getHeading();
        this.velocity = other.getVelocity();
    }

    public StaticVector getRelativeVector(StaticVector other) {
        return new StaticVectorImpl(StaticHeadingImpl.getRelativeAngle(this.heading, other.getHeading()), StaticVelocityImpl.getRelativeVelocity(this.velocity, other.getVelocity()));
    }

    public static StaticVector convertToVector(StaticPosition position) {
        StaticPositionImpl anchor = new StaticPositionImpl(0.0, 0.0);
        double heading = anchor.getBearing(position);
        double velocity = anchor.getDistance(position);
        return new StaticVectorImpl(heading, velocity);
    }

    public boolean equalsVector(StaticVector other) {
        return Constraints.areEqual(this.heading, other.getHeading()) && Constraints.areEqual(this.velocity, other.getVelocity());
    }

    public void debug() {
        Debug.debug("Static Vector: ( " + Debug.trim(this.heading) + ", " + Debug.trim(this.velocity) + " )");
    }

    public String toString() {
        return "( " + Debug.trim(this.heading) + ", " + Debug.trim(this.velocity) + " )";
    }

    public static StaticVector getCompositeVector(StaticVector a, StaticVector b) {
        StaticVector compositeVector;
        if (a == null) {
            compositeVector = b;
        } else if (b == null) {
            compositeVector = a;
        } else {
            DynamicPositionImpl position = new DynamicPositionImpl(a);
            position.add(b);
            compositeVector = StaticPositionImpl.anchor.getRelativeVector(position.getStaticPosition(), a.getHeading());
        }
        return compositeVector;
    }

    public double getHeading() {
        return this.heading;
    }

    public double getRelativeAngle(double other) {
        return StaticHeadingImpl.getRelativeAngle(this.heading, other);
    }

    public double getCompoundAngle(double other) {
        return StaticHeadingImpl.getCompoundAngle(this.heading, other);
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getRelativeVelocity(double other) {
        return StaticVelocityImpl.getRelativeVelocity(this.velocity, other);
    }

    public double getCompoundVelocity(double other) {
        return StaticVelocityImpl.getCompoundVelocity(this.velocity, other);
    }
}

