/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.bot;

import java.awt.Color;
import java.util.Iterator;
import pedersen.debug.Debug;
import pedersen.debug.GraphicalDebugger;
import pedersen.divination.WaveData;
import pedersen.physics.StaticPositionImpl;
import pedersen.tactics.bot.BearingOffsetRange;
import pedersen.tactics.bot.BearingOffsetTracker;

public abstract class GuessFactorBucketBase
implements BearingOffsetTracker {
    protected static final int rawFixedBinSize = 50;
    protected static final int fixedBinSize = 55;
    private static final double maximumValue = 1.0;
    private static final double valuePerIndex = 0.02;
    private static final double indexPerValue = 50.0;
    protected long zero = 0L;
    protected final long[] positive = new long[55];
    protected final long[] negative = new long[55];
    protected long volume = 0L;

    protected GuessFactorBucketBase() {
    }

    protected int convertValueToSignedBinWithOffset(double value) {
        int signedBinWithOffset = 0;
        if (value > 0.0) {
            signedBinWithOffset = 1 + (int)(50.0 * value);
        }
        if (value < 0.0) {
            signedBinWithOffset = -(1 + (int)(50.0 * -value));
        }
        signedBinWithOffset = Math.min(Math.max(signedBinWithOffset, -55), 55);
        return signedBinWithOffset;
    }

    protected double convertSignedBinWithOffsetToValue(int signedBinWithOffset) {
        double value = 0.0;
        if (signedBinWithOffset > 0) {
            value = 0.02 * (double)signedBinWithOffset;
        }
        if (signedBinWithOffset < 0) {
            value = 0.02 * (double)signedBinWithOffset;
        }
        return value;
    }

    protected long getValue(int signedIndex) {
        long value = signedIndex > 0 ? this.positive[signedIndex - 1] : (signedIndex < 0 ? this.negative[-signedIndex - 1] : this.zero);
        return value;
    }

    protected void incrementValue(int signedIndex) {
        if ((signedIndex = Math.max(-55, Math.min(55, signedIndex))) > 0) {
            int n = signedIndex - 1;
            this.positive[n] = this.positive[n] + 1L;
        } else if (signedIndex < 0) {
            int n = -signedIndex - 1;
            this.negative[n] = this.negative[n] + 1L;
        } else {
            ++this.zero;
        }
    }

    public void addWaveData(WaveData waveData) {
        Iterator iterator = waveData.getBearingOffsetRangeIterator();
        while (iterator.hasNext()) {
            this.addRange(waveData.rangeOfMotion, (BearingOffsetRange)iterator.next());
        }
    }

    private void addRange(BearingOffsetRange rangeOfMotion, BearingOffsetRange rangeOfIntercept) {
        double min = rangeOfIntercept.min() / (rangeOfIntercept.min() < 0.0 ? -rangeOfMotion.min() : rangeOfMotion.max());
        double max = rangeOfIntercept.max() / (rangeOfIntercept.max() < 0.0 ? -rangeOfMotion.min() : rangeOfMotion.max());
        int i = this.convertValueToSignedBinWithOffset(min);
        int j = this.convertValueToSignedBinWithOffset(max);
        i = Math.max(i, -55);
        j = Math.min(j, 55);
        while (i <= j) {
            this.incrementValue(i++);
        }
    }

    public void onFire() {
    }

    public void graph() {
        GraphicalDebugger.addRenderableLineSegmentTurnScope(new StaticPositionImpl(345.0, 15.0), new StaticPositionImpl(345.0, 125.0), Color.blue);
        GraphicalDebugger.addRenderableLineSegmentTurnScope(new StaticPositionImpl(350.0, 15.0), new StaticPositionImpl(350.0, 125.0), Color.blue);
        GraphicalDebugger.addRenderableLineSegmentTurnScope(new StaticPositionImpl(400.0, 15.0), new StaticPositionImpl(400.0, 125.0), Color.blue);
        GraphicalDebugger.addRenderableLineSegmentTurnScope(new StaticPositionImpl(450.0, 15.0), new StaticPositionImpl(450.0, 125.0), Color.blue);
        GraphicalDebugger.addRenderableLineSegmentTurnScope(new StaticPositionImpl(455.0, 15.0), new StaticPositionImpl(455.0, 125.0), Color.blue);
        int i = -55;
        while (i <= 55) {
            double value = this.getValue(i);
            if (value > 0.0) {
                GraphicalDebugger.addRenderableLineSegmentTurnScope(new StaticPositionImpl(400 + i, 20.0), new StaticPositionImpl(400 + i, 20.0 + value), Color.pink);
            }
            ++i;
        }
    }

    public void debug() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Visit counts: ");
        buffer.append("[");
        int i = 55;
        while (i > 0) {
            if (i > 0) {
                buffer.append("|");
            }
            if (this.negative[i - 1] > 0L) {
                buffer.append(this.negative[i - 1]);
            }
            --i;
        }
        buffer.append("]");
        buffer.append(" " + this.zero + " ");
        buffer.append("[");
        i = 0;
        while (i < 55) {
            if (i > 0) {
                buffer.append("|");
            }
            if (this.positive[i] > 0L) {
                buffer.append(this.positive[i]);
            }
            ++i;
        }
        buffer.append("]");
        Debug.debug(buffer.toString());
    }
}

