/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.targeting.impl;

import pedersen.core.SnapshotHistory;
import pedersen.divination.CombatWave;
import pedersen.divination.FiringAngle;
import pedersen.misc.Arena;
import pedersen.physics.Projection;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;
import pedersen.tactics.targeting.TargetingMethodBase;

public class TargetingMethodLinearWSCImpl
extends TargetingMethodBase {
    protected StaticPosition firingPosition = null;
    protected SnapshotHistory target;
    protected Projection projectedTarget = null;

    public TargetingMethodLinearWSCImpl() {
        super(2);
    }

    public FiringAngle getFiringAngle(CombatWave wave, long delay, boolean defensive) {
        FiringAngle firingAngle = null;
        this.firingPosition = wave;
        this.target = wave.getVictim();
        SnapshotHistory snapshot = defensive ? this.target.getHistoricalSnapshot(2) : this.target;
        this.projectedTarget = new Projection(snapshot);
        double bulletVelocity = wave.getVelocity();
        double deltaTime = 0.0;
        while ((deltaTime += 1.0) * bulletVelocity < this.projectedTarget.getDistance(wave)) {
            this.projectedTarget.project();
            if (!Arena.isVehicleCenterInBoundary(this.projectedTarget.getStaticPosition())) break;
        }
        double x = Math.min(Math.max(Arena.getMinX(), this.projectedTarget.getX()), Arena.getMaxX());
        double y = Math.min(Math.max(Arena.getMinY(), this.projectedTarget.getY()), Arena.getMaxY());
        firingAngle = new FiringAngle(this, this.firingPosition.getBearing(new StaticPositionImpl(x, y)));
        return firingAngle;
    }
}

