/*
 * Decompiled with CFR 0.152.
 */
package ds.gun;

import ds.DateTime;
import ds.Math2;
import ds.PositionLog;
import ds.gun.AbstractGun;
import ds.gun.IVirtualBullet;
import ds.targeting.IVirtualBot;
import java.awt.geom.Point2D;

public class VirtualBullet
implements IVirtualBullet {
    private AbstractGun m_gun;
    private Point2D.Double m_currentPosition;
    private Point2D.Double m_startPosition;
    private double m_angle;
    private double m_power;
    private boolean m_hasHit;
    private double m_initialDistance;
    private double m_initialTargetVelocity;
    private double m_initialAbsoluteBearingRadians;
    private double m_initialTargetHeadingRadians;
    private double m_turnrate;
    private Point2D.Double m_initialTargetPosition;
    private double m_timeSinceLastDeccel;
    private double m_timeSinceLastAccel;
    private double m_timeSinceLastVelocityInversion;
    private double m_acceleration;
    private double m_lateralAccell;
    private PositionLog m_positionLog;
    private DateTime m_dateTime = DateTime.zero;

    public VirtualBullet(IVirtualBot target, AbstractGun gun, Point2D.Double startPosition, double angle, double power) {
        this.m_gun = gun;
        this.m_startPosition = startPosition;
        this.m_currentPosition = startPosition;
        this.m_angle = angle;
        this.m_power = power;
        if (target != null) {
            this.m_dateTime = target.getDateTime();
            this.m_initialDistance = target.getPosition().distance(startPosition);
            this.m_initialTargetVelocity = target.getVelocity();
            this.m_initialAbsoluteBearingRadians = target.getAbsoluteBearingRadians();
            this.m_initialTargetHeadingRadians = target.getHeadingRadians();
            this.m_turnrate = target.getTurnRate();
            this.m_initialTargetPosition = target.getPosition();
            this.m_timeSinceLastDeccel = target.getTimeSinceLastDeccel();
            this.m_timeSinceLastAccel = target.getTimeSinceLastAccel();
            this.m_timeSinceLastVelocityInversion = target.getTimeSinceLastVelocityInversion();
            this.m_acceleration = target.getAcceleration();
            this.m_lateralAccell = target.getLateralAccell();
            this.m_positionLog = target.getPositionLog().clone();
        }
    }

    @Override
    public Point2D getStartPosition() {
        return this.m_startPosition;
    }

    @Override
    public Point2D getCurrentPosition() {
        return this.m_currentPosition;
    }

    @Override
    public AbstractGun getFiringGun() {
        return this.m_gun;
    }

    @Override
    public double getAngle() {
        return this.m_angle;
    }

    @Override
    public void update() {
        double distance = 20.0 - 3.0 * this.m_power;
        this.m_currentPosition = Math2.getAbsolutePosition(this.m_currentPosition, this.m_angle, distance);
    }

    public double travelDistance() {
        return this.m_startPosition.distance(this.m_currentPosition);
    }

    @Override
    public boolean hasHit() {
        return this.m_hasHit;
    }

    @Override
    public void setHit(boolean b) {
        this.m_hasHit = b;
    }

    public double getInitialDistance() {
        return this.m_initialDistance;
    }

    public double getInitialTargetVelocity() {
        return this.m_initialTargetVelocity;
    }

    public double getInitialAbsoluteBearingRadians() {
        return this.m_initialAbsoluteBearingRadians;
    }

    public double getInitialTargetHeadingRadians() {
        return this.m_initialTargetHeadingRadians;
    }

    public double getTurnRate() {
        return this.m_turnrate;
    }

    public Point2D.Double getInitialTargetPosition() {
        return this.m_initialTargetPosition;
    }

    public double getTimeSinceLastVelocityChange() {
        return Math.min(this.m_timeSinceLastAccel, this.m_timeSinceLastDeccel);
    }

    public double getTimeSinceLastAccel() {
        return this.m_timeSinceLastAccel;
    }

    public double getTimeSinceLastDeccel() {
        return this.m_timeSinceLastDeccel;
    }

    public double getTimeSinceLastVelocityInversion() {
        return this.m_timeSinceLastVelocityInversion;
    }

    public double getAcceleration() {
        return this.m_acceleration;
    }

    @Override
    public double getX() {
        return this.m_currentPosition.getX();
    }

    @Override
    public double getY() {
        return this.m_currentPosition.getY();
    }

    @Override
    public double getHeadingRadians() {
        return this.m_angle;
    }

    public double getLateralAccell() {
        return this.m_lateralAccell;
    }

    public double getBulletPower() {
        return this.m_power;
    }

    public PositionLog getPositionLog() {
        return this.m_positionLog;
    }

    public DateTime getDateTime() {
        return this.m_dateTime;
    }
}

