/*
 * Decompiled with CFR 0.152.
 */
package ds.targeting;

import ds.Versatile;
import ds.targeting.ITargetManager;
import ds.targeting.IVirtualBot;
import ds.targeting.TargetException;
import ds.targeting.VirtualBot;
import robocode.ScannedRobotEvent;

public class TargetManager
implements ITargetManager {
    private int m_lastRoundNum;
    private Versatile m_owner;
    private IVirtualBot m_target;
    private long m_lastScanTime;

    public TargetManager(Versatile owner) {
        this.m_owner = owner;
        this.m_target = null;
    }

    @Override
    public IVirtualBot getCurrentTarget() throws TargetException {
        if (this.m_target == null) {
            throw new TargetException();
        }
        return this.m_target;
    }

    @Override
    public boolean HasTarget() {
        return this.m_target != null;
    }

    @Override
    public void OnScannedRobot(ScannedRobotEvent event) {
        this.m_lastScanTime = event.getTime();
        this.m_lastRoundNum = this.m_owner.getRoundNum();
        if (this.m_target != null && this.m_target.getName() == event.getName()) {
            this.m_target.updateFromScan(this.m_owner, event);
        } else {
            this.m_target = null;
            this.m_target = new VirtualBot(event.getName());
            this.m_target.updateFromScan(this.m_owner, event);
        }
    }

    @Override
    public void Act() {
        if (this.m_owner.getTime() - this.m_lastScanTime > 4L || this.m_owner.getRoundNum() > this.m_lastRoundNum) {
            this.m_target = null;
        }
    }
}

