/*
 * Decompiled with CFR 0.152.
 */
package abc.wiki;

import abc.wiki.BotUtils;
import bts.gun.Gun;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.ScannedRobotEvent;

public class DCGun_1on1
extends Gun {
    private AdvancedRobot bot;
    Point2D enemyLocation;
    double enemyEnergy;
    double enemyDistance;
    boolean aiming;
    public int logLevel = 2;
    public double minBulletPower = 0.1;
    public double maxBulletPower = 3.0;
    boolean referenceMode = false;
    protected long lastAimTime = 0L;
    private int missedScans = 0;
    private int maxSize = 30000;
    private int centerHitDist = 0;
    private double toleranceWidth = 20.0;
    private boolean targetCos = true;
    public ScanInfo first;
    public ScanInfo last;
    public int size = 0;
    private double lastDir = 1.0;
    private double lastRunDir = 1.0;
    private long lastRunStart = 0L;
    private double lastRunTime = 0.0;
    private double lastVel;
    long startTime = 0L;
    double bulletPower = 3.0;
    private long lastTime = 0L;
    private double battleFieldWidth;
    private double battleFieldHeight;
    private double tolerance = 0.0;
    private double nextX = 0.0;
    private double nextY = 0.0;
    private double headOnAngle;

    public DCGun_1on1(AdvancedRobot b) {
        super(b);
        this.bot = b;
        this.battleFieldWidth = this.bot.getBattleFieldWidth();
        this.battleFieldHeight = this.bot.getBattleFieldHeight();
    }

    public void initRound() {
        this.enemyLocation = null;
        this.aiming = false;
    }

    public void cleanUpRound() {
        super.cleanUpRound();
        this.enemyLocation = null;
        if (this.size == 0) {
            return;
        }
        while (this.size > this.maxSize) {
            this.first = this.first.next;
            --this.size;
        }
        this.first.previous = null;
    }

    public double calcBulletPower() {
        double bulletPower = 0.0;
        if (this.enemyLocation == null) {
            return 0.0;
        }
        bulletPower = this.enemyDistance > 150.0 ? 1.9 : 3.0;
        if ((bulletPower = Math.min(bulletPower, (this.enemyEnergy + 0.1) / 4.0)) * 6.0 >= this.bot.getEnergy()) {
            bulletPower = this.bot.getEnergy() / 6.0;
        }
        if (bulletPower >= this.bot.getEnergy() - 0.1) {
            bulletPower = this.bot.getEnergy() - 0.1;
        }
        bulletPower = Math.max(this.minBulletPower, Math.min(this.maxBulletPower, bulletPower));
        if (this.referenceMode) {
            bulletPower = Math.min(this.bot.getEnergy(), 3.0);
        }
        return bulletPower;
    }

    public void execute() {
        Bullet b = null;
        if (this.enemyLocation == null) {
            this.bot.setTurnGunRight(this.bot.getRadarTurnRemaining());
            if (this.bot.getOthers() == 0) {
                this.bot.setFire(0.1);
            }
        } else {
            double nextTurn = this.bot.getTurnRemaining() >= 0.0 ? Math.min(this.bot.getTurnRemaining(), 10.0 - 0.75 * Math.abs(this.bot.getVelocity())) : Math.max(this.bot.getTurnRemaining(), -10.0 + 0.75 * Math.abs(this.bot.getVelocity()));
            double nextD = this.bot.getHeading() + nextTurn;
            this.nextX = this.bot.getX() + this.bot.getVelocity() * BotUtils.sinD(nextTurn);
            this.nextY = this.bot.getY() + this.bot.getVelocity() * BotUtils.cosD(nextTurn);
            this.headOnAngle = BotUtils.angleTo(this.nextX, this.nextY, this.enemyLocation.getX(), this.enemyLocation.getY());
            this.bulletPower = this.calcBulletPower();
            if (this.bot.getGunHeat() > this.bot.getGunCoolingRate() || this.bot.getEnergy() < this.bulletPower || this.bulletPower == 0.0) {
                this.aiming = false;
                this.bot.setTurnGunRight(BotUtils.normalizeBearing(this.headOnAngle - this.bot.getGunHeading()));
            } else if (this.aiming && this.bot.getGunTurnRemaining() == 0.0 && this.bot.getGunHeat() == 0.0) {
                b = this.bot.setFireBullet(this.bulletPower);
                this.aiming = false;
            } else if (!this.aiming) {
                this.lastAimTime = this.bot.getTime();
                double fireAngle = this.findBestAngle();
                if (fireAngle != 10000.0) {
                    this.bot.setTurnGunRight(BotUtils.normalizeBearing(fireAngle - this.bot.getGunHeading()));
                    this.aiming = true;
                } else {
                    this.bot.setTurnGunRight(BotUtils.normalizeBearing(this.headOnAngle - this.bot.getGunHeading()));
                }
            }
        }
        if (b != null) {
            this.bulletFired(b);
        }
    }

    public void update(ScannedRobotEvent e) {
        if (this.referenceMode && this.bot.getEnergy() <= 0.1) {
            return;
        }
        long t1 = this.bot.getTime() - this.startTime;
        if (t1 - this.lastTime > 1L) {
            this.missedScans = (int)((long)this.missedScans + (t1 - this.lastTime - 1L));
        }
        if (t1 - this.lastTime > 20L || t1 < this.lastTime) {
            this.lastRunStart = this.startTime = this.bot.getTime();
        }
        t1 = this.bot.getTime() - this.startTime;
        double dist = e.getDistance();
        double velocity = e.getVelocity();
        double heading = (this.bot.getHeading() + e.getBearing()) % 360.0;
        if (heading < 0.0) {
            heading += 360.0;
        }
        double x = this.bot.getX() + dist * BotUtils.sinD(heading);
        double y = this.bot.getY() + dist * BotUtils.cosD(heading);
        this.enemyLocation = new Point2D.Double(x, y);
        this.enemyEnergy = e.getEnergy();
        this.enemyDistance = dist;
        double d = this.lastDir = velocity != 0.0 ? velocity : this.lastDir;
        if (velocity != this.lastVel) {
            this.lastRunTime = Math.min(40.0, (double)t1 - (double)this.lastRunStart) / 40.0;
            this.lastRunStart = t1;
        }
        this.lastRunDir = this.lastDir;
        heading = this.lastDir < 0.0 ? (e.getHeading() + 180.0) % 360.0 : e.getHeading();
        ScanInfo currInfo = new ScanInfo(x, y, heading, Math.abs(velocity) / 8.0, t1);
        currInfo.dtm = Math.min(e.getDistance(), 800.0) / 800.0;
        currInfo.runTime = Math.min(40.0, (double)(t1 - this.lastRunStart)) / 40.0;
        currInfo.lastRunTime = this.lastRunTime;
        currInfo.myGunHeat = Math.min(1.5, this.bot.getGunHeat()) / 1.5;
        if (Math.abs(this.lastVel) > Math.abs(velocity)) {
            currInfo.acc = 1.0;
        } else if (Math.abs(this.lastVel) < Math.abs(velocity)) {
            currInfo.acc = -1.0;
        }
        this.lastVel = velocity;
        currInfo.atm = Math.abs(BotUtils.normalizeBearing(heading - this.bot.getHeading() - e.getBearing())) / 180.0;
        double maxWDist = 400.0;
        double distV = 0.0;
        double distH = 0.0;
        distV = heading == 90.0 || heading == 270.0 ? Double.POSITIVE_INFINITY : (heading < 90.0 || heading > 270.0 ? (this.battleFieldHeight - y) / BotUtils.cosD(heading) : y / BotUtils.cosD(heading - 180.0));
        distH = heading == 180.0 || heading == 0.0 ? Double.POSITIVE_INFINITY : (heading < 180.0 ? (this.battleFieldWidth - x) / BotUtils.cosD(heading - 90.0) : x / BotUtils.cosD(heading - 180.0 - 90.0));
        currInfo.dtwf = 1.0 - Math.min(Math.min(distV, distH), maxWDist) / maxWDist;
        double h1 = (heading + 180.0) % 360.0;
        if (h1 < 0.0) {
            h1 += 360.0;
        }
        distV = h1 == 90.0 || h1 == 270.0 ? Double.POSITIVE_INFINITY : (h1 < 90.0 || h1 > 270.0 ? (this.battleFieldHeight - y) / BotUtils.cosD(h1) : y / BotUtils.cosD(h1 - 180.0));
        distH = h1 == 180.0 || h1 == 0.0 ? Double.POSITIVE_INFINITY : (h1 < 180.0 ? (this.battleFieldWidth - x) / BotUtils.cosD(h1 - 90.0) : x / BotUtils.cosD(h1 - 180.0 - 90.0));
        currInfo.dtwb = 1.0 - Math.min(Math.min(distV, distH), maxWDist) / maxWDist;
        if (this.size == 0) {
            this.first = currInfo;
            this.last = currInfo;
        } else {
            this.last.next = currInfo;
            currInfo.previous = this.last;
            this.last = currInfo;
        }
        ++this.size;
        this.lastTime = t1;
    }

    public double findBestAngle() {
        int j;
        boolean firedOnlyStats;
        int topCount = 50;
        int angMax = 50;
        boolean bl = firedOnlyStats = this.bot.getRoundNum() > 0 && (double)this.getBulletsHit() / (double)this.getBulletsFired() > 0.12;
        if (firedOnlyStats) {
            topCount = 250;
            angMax = 250;
        }
        ScanInfo info = this.last;
        info.fired = true;
        ScanInfo currentInfo = info;
        double currentDistance = 0.0;
        boolean newRound = true;
        ScanInfo[] topInfo = new ScanInfo[topCount];
        double[] topDiff = new double[topCount];
        double bestAngle = 0.0;
        if (this.last == null) {
            return this.headOnAngle;
        }
        long t1 = info.t;
        long time = (long)(BotUtils.distanceTo(this.bot, this.last.x, this.last.y) / (20.0 - 3.0 * this.bulletPower) * 1.1);
        for (int i = 0; i < topCount; ++i) {
            topDiff[i] = Double.POSITIVE_INFINITY;
            topInfo[i] = currentInfo;
        }
        long iCount = 0L;
        while (info.previous != null) {
            int i;
            if (newRound) {
                t1 = info.t;
                while (info.previous != null && t1 - info.t < time && info.t <= t1) {
                    ++iCount;
                    info = info.previous;
                }
                if (info.t > t1) continue;
                newRound = false;
                continue;
            }
            currentDistance = 0.0;
            currentDistance += DCGun_1on1.sqr(currentInfo.dtm - info.dtm) * 4.0;
            currentDistance += DCGun_1on1.sqr(currentInfo.atm - info.atm);
            currentDistance += DCGun_1on1.sqr(currentInfo.v - info.v) * 2.0;
            currentDistance += DCGun_1on1.sqr(currentInfo.dtwf - info.dtwf) * 4.0;
            currentDistance += DCGun_1on1.sqr(currentInfo.dtwb - info.dtwb);
            currentDistance += DCGun_1on1.sqr(currentInfo.runTime - info.runTime);
            currentDistance += DCGun_1on1.sqr(currentInfo.lastRunTime - info.lastRunTime);
            currentDistance += DCGun_1on1.sqr((currentInfo.acc - info.acc) / 2.0);
            if (firedOnlyStats) {
                currentDistance += DCGun_1on1.sqr(currentInfo.myGunHeat - info.myGunHeat) * 100.0;
            }
            for (i = topCount - 1; i >= 0 && currentDistance < topDiff[i]; --i) {
            }
            if (i < topCount - 1) {
                ++i;
                for (int j2 = topCount - 2; j2 >= i; --j2) {
                    topDiff[j2 + 1] = topDiff[j2];
                    topInfo[j2 + 1] = topInfo[j2];
                }
                topDiff[i] = currentDistance;
                topInfo[i] = info;
            }
            info = info.previous;
            ++iCount;
            if (info.t <= t1) continue;
            newRound = true;
        }
        double[] dists = new double[topCount];
        for (int i = 0; i < topCount; ++i) {
            dists[i] = topDiff[i];
        }
        double[][] angles = new double[topCount][4];
        for (int i = 0; i < topCount; ++i) {
            angles[i][0] = 1000.0;
        }
        int angCount = 0;
        double angSum = 0.0;
        double avgAng = 0.0;
        for (int i = 0; i < topCount && angCount < angMax; ++i) {
            double ang = this.getGunAngle(topInfo[i]);
            if (!(ang < 1000.0)) continue;
            angles[angCount][0] = ang = BotUtils.normalizeBearing(ang - this.headOnAngle);
            angles[angCount][1] = this.tolerance;
            angles[angCount][2] = 1.0;
            angles[angCount][3] = 1.0;
            for (j = 0; j < angCount; ++j) {
                if (!(angles[j][0] < 1000.0)) continue;
                if (Math.abs(angles[j][0] - angles[angCount][0]) < angles[angCount][1]) {
                    double[] dArray = angles[j];
                    dArray[2] = dArray[2] + angles[angCount][3];
                }
                if (!(Math.abs(angles[angCount][0] - angles[j][0]) < angles[j][1])) continue;
                double[] dArray = angles[angCount];
                dArray[2] = dArray[2] + angles[j][3];
            }
            ++angCount;
            angSum += ang;
        }
        double maxCount = 0.0;
        int maxIDX = 0;
        for (j = 0; j < angCount; ++j) {
            if (!(angles[j][2] > maxCount)) continue;
            maxCount = angles[j][2];
            maxIDX = j;
        }
        bestAngle = angles[maxIDX][0];
        if (bestAngle >= 1000.0) {
            bestAngle = 0.0;
        }
        return this.headOnAngle + bestAngle;
    }

    public double getGunAngle(ScanInfo predictedInfo) {
        this.tolerance = 0.0;
        ScanInfo currInfo = this.last;
        ScanInfo endInfo = predictedInfo;
        long timeDelta = this.bot.getTime() - this.startTime - currInfo.t;
        double predx = 0.0;
        double predy = 0.0;
        double predDist = 0.0;
        double bulletSpeed = 20.0 - 3.0 * this.bulletPower;
        for (int i = 0; i < 50; ++i) {
            predDist = BotUtils.distanceTo(endInfo.x, endInfo.y, predictedInfo.x, predictedInfo.y);
            double predAng = 1.5707963267948966 - Math.atan2(endInfo.y - predictedInfo.y, endInfo.x - predictedInfo.x) - Math.toRadians(predictedInfo.d);
            predx = currInfo.x + predDist * Math.sin(Math.toRadians(currInfo.d) + predAng);
            long bulletTime = (long)((predDist = BotUtils.distanceTo(predx, predy = currInfo.y + predDist * Math.cos(Math.toRadians(currInfo.d) + predAng), this.nextX, this.nextY) - (double)this.centerHitDist) / bulletSpeed) + 1L;
            if (Math.abs(endInfo.t - predictedInfo.t - timeDelta - bulletTime) <= 1L) break;
            endInfo = predictedInfo;
            while (endInfo.next != null && endInfo.t >= predictedInfo.t && endInfo.t - predictedInfo.t - timeDelta < bulletTime) {
                endInfo = endInfo.next;
            }
            if (endInfo.next != null && endInfo.t >= predictedInfo.t) continue;
            return Double.POSITIVE_INFINITY;
        }
        if (predx < 0.0 || predx > this.battleFieldWidth || predy < 0.0 || predy > this.battleFieldHeight) {
            return Double.POSITIVE_INFINITY;
        }
        this.tolerance = Math.toDegrees(this.toleranceWidth / predDist);
        return Math.toDegrees(1.5707963267948966 - Math.atan2(predy - this.nextY, predx - this.nextX));
    }

    private static double sqr(double x) {
        return x * x;
    }

    public class ScanInfo {
        public double x = 0.0;
        public double y = 0.0;
        public double d = 0.0;
        public long t = 0L;
        public double v = 0.0;
        public double acc = 0.0;
        public double atm = 0.0;
        public double dtm = 0.0;
        public double dtwf = 0.0;
        public double dtwb = 0.0;
        public double runTime = 0.0;
        public double lastRunTime = 0.0;
        public double myGunHeat = 0.0;
        public boolean fired = false;
        public ScanInfo previous;
        public ScanInfo next;

        public ScanInfo(double x1, double y1, double d1, double v1, long t1) {
            this.x = x1;
            this.y = y1;
            this.d = d1;
            this.v = v1;
            this.t = t1;
        }
    }
}

