/*
 * Decompiled with CFR 0.152.
 */
package stordy;

class Vec2d {
    private double x;
    private double y;

    Vec2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    Vec2d subtract(Vec2d b) {
        return new Vec2d(this.x - b.x, this.y - b.y);
    }

    Vec2d add(Vec2d b) {
        return new Vec2d(this.x + b.x, this.y + b.y);
    }

    Vec2d multiply(double l) {
        return new Vec2d(this.x * l, this.y * l);
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public Vec2d duplicate() {
        return new Vec2d(this.x, this.y);
    }

    public Vec2d limitXY(double minX, double minY, double maxX, double maxY) {
        return new Vec2d(Math.min(maxX, Math.max(minX, this.x)), Math.min(maxY, Math.max(minY, this.y)));
    }

    public Vec2d normalize() {
        double mag = this.getMagnitude();
        if (mag == 0.0) {
            return new Vec2d(0.0, 0.0);
        }
        return this.multiply(1.0 / this.getMagnitude());
    }

    public double getMagnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public static double getDistance(Vec2d a, Vec2d b) {
        return Math.sqrt(Vec2d.getDistanceSquared(a, b));
    }

    public static double getDistanceSquared(Vec2d a, Vec2d b) {
        double dX = a.getX() - b.getX();
        double dY = a.getY() - b.getY();
        return dX * dX + dY * dY;
    }
}

