/*
 * Decompiled with CFR 0.152.
 */
package jdg.tools;

import java.awt.geom.Point2D;
import jdg.tools.BotTrigo;
import jdg.tools.RobotState;

public class BotMove {
    public static final double HALF_BOT_DIAG = 18.0;

    public static boolean ahead(RobotState r, double distance) {
        r.setAhead(distance);
        return false;
    }

    public static void to(RobotState r, Point2D p) {
        BotMove.to(r, p.getX(), p.getY());
    }

    public static void to(RobotState r, double toX, double toY) {
        r.setAheadCoef(1.0);
        double heading = BotTrigo.getHeadingTo(r, toX, toY);
        BotMove.rotate(r, heading);
        BotMove.ahead(r, BotTrigo.getDistanceTo(r, toX, toY));
    }

    public static void rotate(RobotState r, double heading) {
        if (Math.abs(r.getHeading() - heading) < 0.01) {
            return;
        }
        double a = BotTrigo.fixAngle(heading - r.getHeading());
        if (a <= 180.0) {
            r.setTurnRight(a);
        } else {
            r.setTurnLeft(360.0 - a);
        }
    }

    public static double rotateGun(RobotState r, double heading) {
        if (Math.abs(r.getGunHeading() - heading) < 0.01) {
            return Double.NaN;
        }
        double a = BotTrigo.fixAngle(heading - r.getGunHeading());
        if (a <= 180.0) {
            r.setTurnGunRight(a);
        } else {
            r.setTurnGunLeft(360.0 - a);
        }
        return a;
    }

    public static boolean rotateRadar(RobotState r, double heading) {
        double bearing = BotTrigo.fixAngle(heading - r.getRadarHeading());
        if (bearing <= 180.0) {
            r.setTurnRadarRight(bearing);
        } else {
            r.setTurnRadarLeft(360.0 - bearing);
        }
        return true;
    }
}

