/*
 * Decompiled with CFR 0.152.
 */
package ghent.modules.artillery.strategies;

import ghent.common.Target;
import ghent.modules.artillery.TimestampedLocation;
import ghent.modules.artillery.strategies.AbstractTargetingStrategy;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Rules;

public class LinearTargeting
extends AbstractTargetingStrategy {
    static final double ROBOT_HALF_WIDTH = 8.0;
    static final double ROBOT_HALF_HEIGHT = 8.0;

    public LinearTargeting(AdvancedRobot robot) {
        super(robot);
    }

    public LinearTargeting(AdvancedRobot _robot, Double _maxPower) {
        super(_robot, _maxPower);
    }

    public TimestampedLocation getEstimatedLocation(Target enemy, double bPower) {
        double c;
        double a;
        double D;
        double C;
        double eHd;
        double BATTLEFIELD_WIDTH = this._robot.getBattleFieldWidth() - 8.0;
        double BATTLEFIELD_HEIGHT = this._robot.getBattleFieldHeight() - 8.0;
        double bV = Rules.getBulletSpeed((double)bPower);
        double rX = this._robot.getX();
        double rY = this._robot.getY();
        double eX = enemy.getX();
        double eY = enemy.getY();
        double A = (eX - rX) / bV;
        double eV = enemy.getVelocity();
        double B = eV / bV * Math.sin(eHd = Math.toRadians(enemy.getHeading()));
        double b = 2.0 * (A * B + (C = (eY - rY) / bV) * (D = eV / bV * Math.cos(eHd)));
        double discrim = b * b - 4.0 * (a = A * A + C * C) * (c = B * B + D * D - 1.0);
        if (discrim >= 0.0) {
            double t2;
            double t1 = 2.0 * a / (-b - Math.sqrt(discrim));
            double t = Math.min(t1, t2 = 2.0 * a / (-b + Math.sqrt(discrim))) >= 0.0 ? Math.min(t1, t2) : Math.max(t1, t2);
            double endX = LinearTargeting.limit(eX + eV * t * Math.sin(eHd), 8.0, BATTLEFIELD_WIDTH);
            double endY = LinearTargeting.limit(eY + eV * t * Math.cos(eHd), 8.0, BATTLEFIELD_HEIGHT);
            Point2D.Double endLocation = new Point2D.Double(endX, endY);
            double endDist = endLocation.distance(rX, rY);
            double time = endDist / bV;
            return new TimestampedLocation((double)this._robot.getTime() + time, endLocation);
        }
        return null;
    }
}

