/*
 * Decompiled with CFR 0.152.
 */
package catcat20.move;

import catcat20.bot.Bot;
import catcat20.bot.BotState;
import catcat20.radar.Radar;
import catcat20.utils.LUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.TeamRobot;
import robocode.util.Utils;

public class NonWaveMove {
    public TeamRobot robot;
    public boolean isMelee = false;
    public String myName;
    Rectangle2D.Double field;
    Point2D.Double myPos;
    Point2D.Double centerPos;
    double myEnergy;

    public NonWaveMove(TeamRobot _robot) {
        this.robot = _robot;
        this.field = new Rectangle2D.Double(0.0, 0.0, this.robot.getBattleFieldWidth(), this.robot.getBattleFieldHeight());
        this.myName = this.robot.getName();
        this.centerPos = new Point2D.Double(this.robot.getBattleFieldWidth() / 2.0, this.robot.getBattleFieldHeight() / 2.0);
    }

    public void onTick() {
        BotState en;
        this.myEnergy = this.robot.getEnergy();
        this.isMelee = this.robot.getOthers() > 1;
        this.myPos = new Point2D.Double(this.robot.getX(), this.robot.getY());
        Bot nearestBot = Radar.nearestBot;
        if (nearestBot != null && (en = nearestBot.currentState) != null) {
            Graphics2D g = this.robot.getGraphics();
            ArrayList<Object> poss = new ArrayList<Object>();
            Object bestPos = null;
            double bestRisk = Double.POSITIVE_INFINITY;
            Line2D.Double myEnLine = new Line2D.Double(this.myPos.x, this.myPos.y, en.x, en.y);
            double dist = en.distance(this.myPos.x, this.myPos.y);
            if (!this.isMelee) {
                for (double j = 0.0; j < 10.0; j += 1.0) {
                    double ran = Math.random() * 36.0;
                    for (int i = 0; i < 360; i += 10) {
                        double length = Math.random() * dist;
                        Pos pos = new Pos();
                        pos.pos = LUtils.project(this.myPos, Math.toRadians((double)i + ran), length);
                        pos.pos = this.chkOutOfField(pos.pos);
                        if (myEnLine.ptLineDist(pos.pos) <= 20.0) continue;
                        pos.risk = this.getRisk(pos.pos, en);
                        if (bestRisk > pos.risk) {
                            bestPos = pos;
                            bestRisk = pos.risk;
                        }
                        poss.add(pos);
                    }
                }
            } else {
                double count = 100.0;
                double length = 100.0 + Math.random() * 100.0;
                length = Math.min(this.myPos.distance(en.x, en.y), length);
                for (double i = 0.0; i < 360.0; i += 360.0 / count) {
                    Pos pos = new Pos();
                    pos.pos = LUtils.project(this.myPos, Math.toRadians(i), length);
                    pos.pos = this.chkOutOfField(pos.pos);
                    if (myEnLine.ptLineDist(pos.pos) <= 20.0) continue;
                    pos.risk = this.getRisk(pos.pos, en);
                    if (bestRisk > pos.risk) {
                        bestPos = pos;
                        bestRisk = pos.risk;
                    }
                    poss.add(pos);
                }
            }
            if (bestPos != null) {
                this.goTo(((Pos)bestPos).pos.x, ((Pos)bestPos).pos.y);
            }
            double[] risks = new double[poss.size()];
            int x = 0;
            double lowestRisk = Double.POSITIVE_INFINITY;
            double highestRisk = Double.NEGATIVE_INFINITY;
            for (Pos pos : poss) {
                risks[x++] = pos.risk;
                if (pos.risk < lowestRisk) {
                    lowestRisk = pos.risk;
                }
                if (!(pos.risk > highestRisk)) continue;
                highestRisk = pos.risk;
            }
            double avg = NonWaveMove.average(risks);
            double stDev = NonWaveMove.standardDeviation(risks);
            for (Pos pos : poss) {
                g.setColor(NonWaveMove.riskColor(pos.risk - lowestRisk, avg - lowestRisk, stDev, true, 1.0));
                if (pos.risk <= bestRisk || pos.risk <= lowestRisk) {
                    g.setColor(Color.yellow);
                }
                g.fillOval((int)pos.pos.x - 3, (int)pos.pos.y - 3, 6, 6);
            }
            if (bestPos != null) {
                g.setColor(Color.yellow);
                g.fillOval((int)((Pos)bestPos).pos.x - 5, (int)((Pos)bestPos).pos.y - 5, 10, 10);
            }
            if (nearestBot != null && nearestBot.currentState != null && nearestBot.currentState.energy <= 0.0) {
                this.goTo(nearestBot.currentState.x, nearestBot.currentState.y);
            }
        }
    }

    public double getDuelRisk(Point2D.Double pos, BotState enemy) {
        double risk = 0.0;
        double absBearing = LUtils.absoluteBearing(enemy.x, enemy.y, this.myPos.x, this.myPos.y);
        double goAngle = LUtils.absoluteBearing(this.myPos, pos);
        double sui = 1.0 + Math.abs(Math.cos(absBearing - goAngle));
        sui = Math.pow(sui, 0.15);
        double dist = pos.distance(enemy.x, enemy.y) * 1.5;
        risk += 60.0 * (1.0 + sui) / Math.pow(dist, 2.0);
        if (enemy.energy < 1.0) {
            risk -= 120.0 * (1.0 + sui) / Math.pow(dist, 2.0);
        }
        for (double[] edge : this.getEdges()) {
            risk += 5.0 / (1.0 + Line2D.ptSegDistSq(edge[0], edge[1], edge[2], edge[3], pos.x, pos.y));
        }
        for (double[] corner : this.getCorners()) {
            corner[0] = (corner[0] + enemy.x) / 2.0;
            corner[1] = (corner[1] + enemy.y) / 2.0;
            if (!(Point2D.Double.distanceSq(enemy.x, enemy.y, corner[0], corner[1]) < 22500.0)) continue;
            risk += 5.0 / (1.0 + pos.distanceSq(corner[0], corner[1]));
        }
        return risk;
    }

    public double getMeleeRisk(Point2D.Double pos) {
        double risk = 0.0;
        double goAngle = LUtils.absoluteBearing(this.myPos, pos);
        for (Bot bot : Radar.enemies.values()) {
            if (!bot.isAlive || bot.currentState == null) continue;
            BotState en = bot.currentState;
            double energyRatio = Math.min(en.energy / this.myEnergy, 2.0);
            double distance = pos.distance(en.x, en.y);
            int closer = Radar.botsCloser(distance * distance * 0.8);
            double absBearing = LUtils.absoluteBearing(en.x, en.y, pos.x, pos.y);
            double sui = 1.0 + Math.abs(Math.cos(absBearing - goAngle));
            risk += energyRatio * (1.0 + sui) / (distance * (double)closer * Math.pow(this.centerPos.distanceSq(pos), 0.125));
        }
        return risk;
    }

    public double getRisk(Point2D.Double pos, BotState enemy) {
        double risk = 0.0;
        risk = !this.isMelee ? (risk += this.getDuelRisk(pos, enemy)) : (risk += this.getMeleeRisk(pos));
        return risk;
    }

    public double[][] getCorners() {
        return new double[][]{{this.field.x, this.field.y}, {this.field.x, this.field.y + this.field.getHeight()}, {this.field.x + this.field.width, this.field.y}, {this.field.x + this.field.width, this.field.y + this.field.height}};
    }

    public double[][] getEdges() {
        return new double[][]{{this.field.x, this.field.y, this.field.x + this.field.width, this.field.y}, {this.field.x, this.field.y, this.field.x, this.field.y + this.field.height}, {this.field.x, this.field.y + this.field.height, this.field.x + this.field.width, this.field.y + this.field.height}, {this.field.x + this.field.width, this.field.y, this.field.x + this.field.width, this.field.y + this.field.height}};
    }

    public Point2D.Double chkOutOfField(Point2D.Double p) {
        return new Point2D.Double(LUtils.limit(35.0, p.x, this.field.width - 35.0), LUtils.limit(35.0, p.y, this.field.height - 35.0));
    }

    private void goTo(double x, double y) {
        double angleToTarget = Math.atan2(x -= this.robot.getX(), y -= this.robot.getY());
        double targetAngle = Utils.normalRelativeAngle((double)(angleToTarget - this.robot.getHeadingRadians()));
        double distance = Math.hypot(x, y);
        double turnAngle = Math.atan(Math.tan(targetAngle));
        this.robot.setTurnRightRadians(turnAngle);
        if (targetAngle == turnAngle) {
            this.robot.setAhead(distance);
        } else {
            this.robot.setBack(distance);
        }
    }

    public static double standardDeviation(double[] values) {
        double avg = NonWaveMove.average(values);
        double sumSquares = 0.0;
        for (int x = 0; x < values.length; ++x) {
            sumSquares += NonWaveMove.square(avg - values[x]);
        }
        return Math.sqrt(sumSquares / (double)values.length);
    }

    public static double square(double d) {
        return d * d;
    }

    public static double average(double[] values) {
        double sum = 0.0;
        for (int x = 0; x < values.length; ++x) {
            sum += values[x];
        }
        return sum / (double)values.length;
    }

    public static Color riskColor(double risk, double avg, double stDev, boolean safestYellow, double maxStDev) {
        if (risk < 1.0E-7 && safestYellow) {
            return Color.yellow;
        }
        return new Color((int)LUtils.limit(0.0, 255.0 * (risk - (avg - maxStDev * stDev)) / (2.0 * maxStDev * stDev), 255.0), 0, (int)LUtils.limit(0.0, 255.0 * (avg + maxStDev * stDev - risk) / (2.0 * maxStDev * stDev), 255.0));
    }

    public class Pos {
        public Point2D.Double pos;
        public double risk;
    }
}

