/*
 * Decompiled with CFR 0.152.
 */
package pac;

import java.awt.Color;
import pac.Intercept;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public class ABC
extends Robot {
    private int mov = 1;

    public void run() {
        this.setBodyColor(Color.black);
        this.setGunColor(Color.black);
        this.setRadarColor(Color.pink);
        this.setBulletColor(Color.pink);
        this.setScanColor(Color.pink);
        this.setAdjustGunForRobotTurn(false);
        this.turnGunRight(90.0);
        while (true) {
            this.ahead(100.0);
            this.turnGunRight(180.0);
            this.ahead(100.0);
            this.turnGunRight(180.0);
            this.ahead(100.0);
            this.turnGunRight(45.0);
            this.ahead(100.0);
            this.turnRight(45.0);
        }
    }

    public double normaliza(double ang) {
        while (ang > 180.0) {
            ang -= 360.0;
        }
        while (ang < -180.0) {
            ang += 360.0;
        }
        return ang;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double pot = 1.0;
        if (e.getDistance() <= 100.0) {
            pot = 3.0;
        }
        if (e.getDistance() > 100.0 && e.getDistance() <= 300.0) {
            pot = 2.5;
        }
        if (e.getDistance() > 300.0 && e.getDistance() <= 800.0) {
            pot = 1.8;
        }
        if (e.getDistance() > 800.0) {
            pot = 1.5;
        }
        if (e.getEnergy() == 0.0) {
            pot = 0.1;
        }
        double teta = e.getBearing() + this.getHeading() - 90.0;
        double targetStartingPointX = this.getX() + Math.cos(Math.toRadians(teta)) * e.getDistance();
        double targetStartingPointY = this.getY() - Math.sin(Math.toRadians(teta)) * e.getDistance();
        Intercept intercept = new Intercept();
        intercept.calculate(this.getX(), this.getY(), targetStartingPointX, targetStartingPointY, e.getHeading(), e.getVelocity(), pot, 0.0);
        double turnAngle = this.normaliza(intercept.bulletHeading_deg - this.getGunHeading());
        this.turnGunRight(turnAngle);
        if (intercept.impactPoint.x > 0.0 && intercept.impactPoint.x < this.getBattleFieldWidth() && intercept.impactPoint.y > 0.0 && intercept.impactPoint.y < this.getBattleFieldHeight()) {
            this.fire(pot);
        }
    }

    public void onHitRobot(HitRobotEvent e) {
        double tot = 0.0;
        tot = e.getBearing() + (this.getHeading() - this.getGunHeading());
        this.turnGunRight(this.normaliza(tot));
        if (this.getEnergy() < 15.0) {
            this.fire(1.5);
        } else {
            this.fire(3.0);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        double tot = 0.0;
        double angFoge = 45.0;
        double kmFoge = 70.0;
        tot = e.getBearing() + (this.getHeading() - this.getGunHeading()) + angFoge - 90.0;
        this.turnLeft(angFoge);
        this.ahead(kmFoge);
        this.mov *= -1;
        this.turnGunRight(this.normaliza(tot));
        this.scan();
    }

    public void onHitWall(HitWallEvent e) {
        double ang = 0.0;
        ang = e.getBearing();
        if (ang > 0.0) {
            this.turnLeft(ang);
        } else {
            this.turnRight(-1.0 * ang);
        }
        this.ahead(100.0);
    }

    public void onWin(WinEvent e) {
        int i = 0;
        while (i < 50) {
            this.turnRight(60.0);
            this.turnLeft(90.0);
            ++i;
        }
    }
}

