/*
 * Decompiled with CFR 0.152.
 */
package rdt199.tracking;

import rdt199.gun.GunMode;
import rdt199.util.BotFuncs;
import rdt199.util.Location;
import rdt199.util.RobotLog;
import rdt199.util.RobotSnapshot;
import robocode.Condition;

public class VirtualBullet
extends Condition {
    GunMode m_Mode;
    RobotLog m_Target;
    Location m_StartingLocation;
    double m_dAngle;
    double m_dFirepower;
    double m_dVelocity;
    double m_dVelocityFactor;
    long m_lStartingTime;
    boolean m_bHit;

    public VirtualBullet(double degangle, double firepower, Location start, RobotLog target, GunMode mode) {
        this.m_dAngle = degangle;
        this.m_dFirepower = firepower;
        this.m_dVelocity = 20.0 - 3.0 * firepower;
        this.m_lStartingTime = BotFuncs.m_AdvancedRobot.getTime();
        this.m_StartingLocation = start;
        this.m_Target = target;
        this.m_bHit = false;
        this.m_Mode = mode;
        BotFuncs.m_AdvancedRobot.addCustomEvent((Condition)this);
    }

    public VirtualBullet(double degangle, double firepower, Location start, RobotLog target, GunMode mode, double velfactor) {
        this.m_dAngle = degangle;
        this.m_dFirepower = firepower;
        this.m_dVelocity = 20.0 - 3.0 * firepower;
        this.m_dVelocityFactor = velfactor;
        this.m_lStartingTime = BotFuncs.m_AdvancedRobot.getTime();
        this.m_StartingLocation = start;
        this.m_Target = target;
        this.m_bHit = false;
        this.m_Mode = mode;
        BotFuncs.m_AdvancedRobot.addCustomEvent((Condition)this);
    }

    public boolean test() {
        double dTimeDiff = (double)BotFuncs.m_AdvancedRobot.getTime() - (double)this.m_lStartingTime - 1.0;
        if (this.outsideArena()) {
            BotFuncs.m_AdvancedRobot.removeCustomEvent((Condition)this);
            return true;
        }
        if (!this.m_Target.isAlive()) {
            BotFuncs.m_AdvancedRobot.removeCustomEvent((Condition)this);
            return true;
        }
        RobotSnapshot Snap = this.m_Target.get(0);
        if (Snap == null) {
            return false;
        }
        if (Snap.m_lTime != BotFuncs.m_AdvancedRobot.getTime() - 1L) {
            return false;
        }
        Location Target = Snap.m_Location;
        if (this.getDistance(Target, dTimeDiff) > 50.0) {
            return false;
        }
        double dFraction = 0.0;
        while (dFraction < 1.05) {
            if (this.getDistance(Target, dTimeDiff - dFraction) < 22.5) {
                this.m_bHit = true;
                BotFuncs.m_AdvancedRobot.removeCustomEvent((Condition)this);
                return true;
            }
            dFraction += 0.1;
        }
        return false;
    }

    public boolean hitTarget() {
        return this.m_bHit;
    }

    public boolean outsideArena() {
        double dTimeDiff = (double)BotFuncs.m_AdvancedRobot.getTime() - (double)this.m_lStartingTime;
        Location Loc = this.getBulletLocation(dTimeDiff);
        return !BotFuncs.isInBattlefield(Loc);
    }

    public GunMode getMode() {
        return this.m_Mode;
    }

    public double getFirepower() {
        return this.m_dFirepower;
    }

    public double getVelocityFactor() {
        return this.m_dVelocityFactor;
    }

    private Location getBulletLocation(double timediff) {
        double dDistance = this.getBulletDistance(timediff);
        double dCurrentX = this.m_StartingLocation.getX() + Math.sin(Math.toRadians(this.m_dAngle)) * dDistance;
        double dCurrentY = this.m_StartingLocation.getY() + Math.cos(Math.toRadians(this.m_dAngle)) * dDistance;
        return new Location(dCurrentX, dCurrentY);
    }

    private double getBulletDistance(double timediff) {
        return timediff * this.m_dVelocity;
    }

    private double getDistance(Location loc, double timediff) {
        Location Bullet2 = this.getBulletLocation(timediff);
        return BotFuncs.getDistanceBetween(Bullet2, loc);
    }
}

