/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy.analysis;

import alk.lap.LoudAndProud;
import alk.lap.bothandling.Gunner;
import alk.lap.strategy.StrategicLead;
import alk.lap.strategy.analysis.AnalystsDatabase;
import alk.lap.utils.DVektor;
import java.util.HashMap;
import java.util.TreeSet;

public class VirtualHitHistory {
    private HashMap<String, Integer> statistic = new HashMap(40);
    private int count = 0;

    public void incrementHit(String strategyName) {
        Integer oldScore = this.statistic.get(strategyName);
        this.statistic.put(strategyName, new Integer(oldScore == null ? 1 : oldScore + 1));
        ++this.count;
    }

    public int getHitCount(String strategyName) {
        Integer score = this.statistic.get(strategyName);
        if (score != null) {
            return score;
        }
        return 0;
    }

    public int getCount() {
        return this.count;
    }

    public static void paintHitStat(LoudAndProud proud, VirtualHitHistory stat, boolean near) {
        int startX = 10 + (near ? 0 : 120);
        int startY = 50;
        int lineDistance = 16;
        int barWidthHalf = 8;
        double dist = near ? AnalystsDatabase.THRESHOLD_NEAR_FAR - 1.0 : AnalystsDatabase.THRESHOLD_NEAR_FAR + 1.0;
        AnalystsDatabase.StatMax maxStratC = proud.getStrategicLead().getAnalystsDB().getBestTargetStrategy(dist);
        double scaleToMax = maxStratC.score == 0.0 ? 1.0 : 100.0 / maxStratC.score;
        TreeSet<AnalystsDatabase.StatMax> sortedHist = new TreeSet<AnalystsDatabase.StatMax>();
        for (Gunner gunner : proud.getStrategicLead().allGunners()) {
            double count = proud.getStrategicLead().getAnalystsDB().getDamageOfStrategy(gunner.getTargetStrategy(), dist);
            sortedHist.add(new AnalystsDatabase.StatMax(gunner.getTargetStrategy().describe(), count));
        }
        int i = 0;
        for (AnalystsDatabase.StatMax statCount : sortedHist) {
            double width = statCount.score * scaleToMax;
            proud.getVc().drawRect(new DVektor(startX, startY + i * lineDistance - barWidthHalf), new DVektor((double)startX + width, startY + i * lineDistance + barWidthHalf), String.valueOf(statCount.score == maxStratC.score ? "*" : "") + proud.printDouble(statCount.score) + ":" + statCount.name, proud.getStrategicLead().getGunner(statCount.name).getTargetStrategy().getColorCode());
            ++i;
        }
        proud.getVc().drawPoint(new DVektor(startX, startY), near ? "near" : "far");
    }

    public static String printHitStat() {
        StringBuffer values = new StringBuffer();
        StrategicLead statLead = LoudAndProud.getStaticStrategicLead();
        values.append("far;");
        for (Gunner gunner : statLead.allGunners()) {
            values.append(String.valueOf(gunner.getTargetStrategy().describe()) + "=" + statLead.getAnalystsDB().getDamageOfStrategy(gunner.getTargetStrategy(), AnalystsDatabase.THRESHOLD_NEAR_FAR + 1.0) + ";");
        }
        return values.toString();
    }

    public static String hitStatCSVHead() {
        StringBuffer aBuf = new StringBuffer();
        StrategicLead statLead = LoudAndProud.getStaticStrategicLead();
        aBuf.append("dist");
        for (Gunner gunner : statLead.allGunners()) {
            aBuf.append(";");
            aBuf.append(gunner.getTargetStrategy().describe());
        }
        return aBuf.toString();
    }

    public static String hitStatCSVLine() {
        StringBuffer aBuf = new StringBuffer();
        StrategicLead statLead = LoudAndProud.getStaticStrategicLead();
        aBuf.append("far");
        for (Gunner gunner : statLead.allGunners()) {
            aBuf.append(";");
            aBuf.append(LoudAndProud.printStaticDoubleDE(statLead.getAnalystsDB().getDamageOfStrategy(gunner.getTargetStrategy(), AnalystsDatabase.THRESHOLD_NEAR_FAR + 1.0)));
        }
        return aBuf.toString();
    }
}

