/*
 * Decompiled with CFR 0.152.
 */
package com.cgarias.rc;

import lessons.EnemyBot;
import robocode.Robot;
import robocode.ScannedRobotEvent;

public class AdvancedEnemyBot
extends EnemyBot
implements Comparable {
    private static double distanceFactor = 50.0;
    private static double energyFactor = 0.0;
    private static double firingFactor = 0.0;
    private double x;
    private double y;
    private double priority;

    public AdvancedEnemyBot() {
        this.reset();
    }

    public AdvancedEnemyBot(ScannedRobotEvent e, Robot robot) {
        this.update(e, robot);
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void reset() {
        super.reset();
        this.x = 0.0;
        this.y = 0.0;
    }

    public void update(ScannedRobotEvent e, Robot robot) {
        super.update(e);
        double absBearingDeg = robot.getHeading() + e.getBearing();
        if (absBearingDeg < 0.0) {
            absBearingDeg += 360.0;
        }
        this.x = robot.getX() + Math.sin(Math.toRadians(absBearingDeg)) * e.getDistance();
        this.y = robot.getY() + Math.cos(Math.toRadians(absBearingDeg)) * e.getDistance();
        this.updatePriority();
    }

    public double getFutureX(long when) {
        return this.x + Math.sin(Math.toRadians(this.getHeading())) * this.getVelocity() * (double)when;
    }

    public double getFutureY(long when) {
        return this.y + Math.sin(Math.toRadians(this.getHeading())) * this.getVelocity() * (double)when;
    }

    private void updatePriority() {
        this.priority = this.getDistance() * distanceFactor + this.getEnergy() * energyFactor;
    }

    public void setPriority(double priority) {
        this.priority = priority;
    }

    public double getPriority() {
        return this.priority;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        AdvancedEnemyBot aeb = (AdvancedEnemyBot)o;
        if (this.priority < aeb.getPriority()) {
            return -1;
        }
        if (this.priority > aeb.getPriority()) {
            return 1;
        }
        return 0;
    }
}

