/*
 * Decompiled with CFR 0.152.
 */
package com.cohesiva.robocode;

import com.cohesiva.robocode.AntiGravMovement;
import com.cohesiva.robocode.Enemy;
import com.cohesiva.robocode.Utils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.Hashtable;
import java.util.Map;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class ManOwaR
extends AdvancedRobot {
    Map<String, Enemy> enemies;
    private Enemy currentTarget;
    int direction = 1;
    double firePower;
    double midpointstrength = 0.0;
    int midpointcount = 0;
    private AntiGravMovement movementStrategy;
    private Point point;

    public void run() {
        this.movementStrategy = new AntiGravMovement(this);
        this.enemies = new Hashtable<String, Enemy>();
        this.setColors(Color.black, Color.red, Color.blue);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.turnRadarRightRadians(Math.PI * 2);
        while (true) {
            this.antiGravMove();
            this.doFirePower();
            this.doScanner();
            this.doGun();
            this.fire(this.firePower);
            this.execute();
        }
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.RED);
        g.fillRect(this.point.x - 3, this.point.y - 3, 6, 6);
        g.fillRect((int)this.movementStrategy.attractionPoint.getX() - 3, (int)this.movementStrategy.attractionPoint.getY() - 3, 6, 6);
    }

    void doFirePower() {
        this.firePower = 400.0 / this.currentTarget.getDistance();
        if (this.firePower > 3.0) {
            this.firePower = 3.0;
        }
    }

    void antiGravMove() {
        double xforce = this.movementStrategy.getXforce();
        double yforce = this.movementStrategy.getYforce();
        this.goTo(this.getX() - xforce, this.getY() - yforce);
    }

    void goTo(double x, double y) {
        double dist = 40.0;
        double absBearing = Utils.absBearing(this.getX(), this.getY(), x, y);
        double angle = Utils.normaliseBearing(this.getHeading() - Math.toDegrees(absBearing));
        double r = this.turnTo(angle);
        double turnRemaining = angle % 180.0;
        if (turnRemaining < 60.0 || turnRemaining > 120.0) {
            this.setAhead(dist * r);
        } else {
            this.setAhead(0.0);
        }
        double bearingRemaining = Math.toRadians(this.getHeading() + this.getTurnRemaining()) * r;
        this.point = new Point((int)(this.getX() + Math.sin(bearingRemaining) * dist), (int)(this.getY() + Math.cos(bearingRemaining) * dist));
    }

    int turnTo(double ang) {
        int dir;
        if (ang > 90.0) {
            ang -= 180.0;
            dir = -1;
        } else if (ang < -90.0) {
            ang += 180.0;
            dir = -1;
        } else {
            dir = 1;
        }
        this.setTurnLeft(ang);
        return dir;
    }

    void doScanner() {
        this.setTurnRadarLeftRadians(Math.PI * 2);
    }

    void doGun() {
        long time = this.getTime() + (long)((int)Math.round(Utils.getRange(this.getX(), this.getY(), this.currentTarget.getX(), this.currentTarget.getY()) / (20.0 - 3.0 * this.firePower)));
        Point2D.Double p = this.currentTarget.guessPosition(time);
        double gunOffset = this.getGunHeadingRadians() - (1.5707963267948966 - Math.atan2(p.y - this.getY(), p.x - this.getX()));
        this.setTurnGunLeftRadians(Utils.normaliseBearing(gunOffset));
    }

    double normaliseHeading(double ang) {
        if (ang > Math.PI * 2) {
            ang -= Math.PI * 2;
        }
        if (ang < 0.0) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Enemy en;
        if (this.enemies.containsKey(e.getName())) {
            en = this.enemies.get(e.getName());
        } else {
            en = new Enemy();
            this.enemies.put(e.getName(), en);
        }
        double absbearing_rad = (this.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
        en.setName(e.getName());
        double h = Utils.normaliseBearing(e.getHeadingRadians() - en.getHeading());
        en.setChanhehead(h /= (double)(this.getTime() - en.getScannedTime()));
        en.setX(this.getX() + Math.sin(absbearing_rad) * e.getDistance());
        en.setY(this.getY() + Math.cos(absbearing_rad) * e.getDistance());
        en.setBearing(e.getBearingRadians());
        en.setHeading(e.getHeadingRadians());
        en.setScannedTime(this.getTime());
        en.setSpeed(e.getVelocity());
        en.setDistance(e.getDistance());
        en.setLive(true);
        if (this.currentTarget == null || en.getDistance() < this.currentTarget.getDistance() || !this.currentTarget.isLive()) {
            this.currentTarget = en;
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        Enemy en = this.enemies.get(e.getName());
        en.setLive(false);
    }

    public Map<String, Enemy> getEnemies() {
        return this.enemies;
    }

    public Enemy getCurrentTarget() {
        return this.currentTarget;
    }

    public void onHitByBullet(HitByBulletEvent event) {
        this.movementStrategy.onHitByBullet(event);
    }
}

