/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics;

import pedersen.core.Snapshot;
import pedersen.physics.Line;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;

public class StaticLineWithMidpointImpl
extends StaticPositionImpl
implements Line {
    private final double m;
    private final double b;

    public StaticLineWithMidpointImpl(Snapshot snapshot) {
        super(snapshot);
        this.m = Math.atan(snapshot.getHeading());
        this.b = this.getY() - this.m * this.getX();
    }

    public StaticLineWithMidpointImpl(StaticPosition position, double heading) {
        super(position);
        this.m = Math.atan(heading);
        this.b = this.getY() - this.m * this.getX();
    }

    public double getSlope() {
        return this.m;
    }

    public double getOffset() {
        return this.b;
    }

    public StaticPosition getPointOfIntersection(Line other) {
        StaticPositionImpl pointOfIntersection = null;
        if (other != null && other.getSlope() != this.m) {
            double x = (other.getOffset() - this.b) / (this.m - other.getSlope());
            double y = this.m * x + this.b;
            pointOfIntersection = new StaticPositionImpl(x, y);
        }
        return pointOfIntersection;
    }
}

