/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.grail;

import java.util.Iterator;
import pedersen.divination.WaveData;
import pedersen.physics.StaticLineWithMidpointImpl;
import pedersen.physics.StaticPosition;
import pedersen.tactics.grail.BearingOffsetRange;
import pedersen.tactics.grail.SegmentBase;
import pedersen.tactics.targeting.TargetingMethodBase;

public class SegmentLinearProjectionImpl
extends SegmentBase {
    public static final int fixedBinSize = 50;
    private static final double maximumValue = 1.0;
    private long zero = 0L;
    private final long[] positive = new long[this.positiveBinSize];
    private final long[] negative = new long[this.negativeBinSize];

    SegmentLinearProjectionImpl() {
        super(1.0, 50, 50);
    }

    protected void buildOrganicBins() {
    }

    public void addWaveData(WaveData waveData) {
        Iterator iterator = waveData.getBearingOffsetRangeIterator();
        while (iterator.hasNext()) {
            this.addRange(waveData, (BearingOffsetRange)iterator.next());
        }
    }

    private void addRange(WaveData waveData, BearingOffsetRange bearingOffsetRange) {
        block13: {
            int max;
            int min;
            double targetVelocityToInterceptB;
            double targetVelocityPercentageB;
            if (!waveData.isLinearProjectionDataAvailable) break block13;
            double targetVelocityToInterceptA = this.getTargetVelocityToIntercept(waveData, bearingOffsetRange.min(), bearingOffsetRange.getVelocity());
            double targetVelocityPercentageA = targetVelocityToInterceptA / waveData.originalTargetVelocity;
            if (targetVelocityPercentageA > (targetVelocityPercentageB = (targetVelocityToInterceptB = this.getTargetVelocityToIntercept(waveData, bearingOffsetRange.min(), bearingOffsetRange.getVelocity())) / waveData.originalTargetVelocity)) {
                min = this.convertValueToSignedBinWithOffset(-targetVelocityPercentageA);
                max = this.convertValueToSignedBinWithOffset(-targetVelocityPercentageB);
            } else {
                min = this.convertValueToSignedBinWithOffset(targetVelocityPercentageA);
                max = this.convertValueToSignedBinWithOffset(targetVelocityPercentageB);
            }
            if (max > -this.negativeBinSize && min < this.positiveBinSize) {
                if (min < -this.negativeBinSize) {
                    min = -this.negativeBinSize;
                }
                if (max > this.positiveBinSize) {
                    max = this.positiveBinSize;
                }
                if (min > 0) {
                    int i = min;
                    while (i < this.positiveBinSize && i <= max) {
                        int n = i - 1;
                        this.positive[n] = this.positive[n] + 1L;
                        ++i;
                    }
                } else if (max < 0) {
                    int i = -max;
                    while (i < this.negativeBinSize && i <= -min) {
                        int n = i - 1;
                        this.negative[n] = this.negative[n] + 1L;
                        ++i;
                    }
                } else {
                    ++this.zero;
                    int i = 1;
                    while (i < this.positiveBinSize && i <= max) {
                        int n = i - 1;
                        this.positive[n] = this.positive[n] + 1L;
                        ++i;
                    }
                    i = 1;
                    while (i < this.negativeBinSize && i <= -min) {
                        int n = i - 1;
                        this.negative[n] = this.negative[n] + 1L;
                        ++i;
                    }
                }
            }
        }
    }

    private double getTargetVelocityToIntercept(WaveData waveData, double bearingOffset, double velocity) {
        double bearing = waveData.originalBearingToTarget + bearingOffset;
        StaticLineWithMidpointImpl line = new StaticLineWithMidpointImpl(waveData.originalFiringPosition, bearing);
        StaticPosition intercept = waveData.originalTargetPositionWithDirectionOfTravel.getPointOfIntersection(line);
        double distanceFromFiringPosition = waveData.originalFiringPosition.getDistance(intercept);
        int timeToIntercept = TargetingMethodBase.getBulletFlightTime(distanceFromFiringPosition, velocity);
        double distanceFromTargetPosition = waveData.originalTargetPositionWithDirectionOfTravel.getDistance(intercept);
        double targetVelocityToIntercept = distanceFromTargetPosition / (double)timeToIntercept;
        return targetVelocityToIntercept;
    }

    public double getMostVisitedValue(WaveData waveData) {
        int mostVisitedSignedBinWithOffset = 0;
        long mostVisitedCount = this.zero;
        int i = 0;
        while (i < this.positiveBinSize) {
            if (this.positive[i] > mostVisitedCount) {
                mostVisitedSignedBinWithOffset = i + 1;
                mostVisitedCount = this.positive[i];
            }
            ++i;
        }
        i = 0;
        while (i < this.negativeBinSize) {
            if (this.negative[i] > mostVisitedCount) {
                mostVisitedSignedBinWithOffset = -(i + 1);
                mostVisitedCount = this.negative[i];
            }
            ++i;
        }
        return this.convertSignedBinWithOffsetToValue(mostVisitedSignedBinWithOffset);
    }

    public long getHitCountByIndex(int index) {
        long hitCount = this.zero;
        if (index > 0) {
            hitCount = this.positive[index - 1];
        } else if (index < 0) {
            hitCount = this.negative[-index - 1];
        }
        return hitCount;
    }

    public void debug() {
    }
}

