/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.movement.impl;

import java.util.Iterator;
import pedersen.core.Snapshot;
import pedersen.debug.profiling.Stopwatches;
import pedersen.divination.CombatWave;
import pedersen.divination.FiringAngle;
import pedersen.divination.WaveInboundBank;
import pedersen.physics.DynamicPositionImpl;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;
import pedersen.physics.StaticVectorImpl;
import pedersen.tactics.movement.MovementMethodFieldBase;

public class MovementMethodFieldBulletImpl
extends MovementMethodFieldBase {
    private static final double alwaysOnRangeDefault = 100.0;
    private static final double alwaysOnPowerDefault = 16.0;
    public static final double fieldMagnitudeDefault = 0.0;

    public MovementMethodFieldBulletImpl() {
        super(18, 0.0, 100.0, 16.0);
    }

    public MovementMethodFieldBulletImpl(double newFieldMagnitude) {
        super(18, newFieldMagnitude, 100.0, 16.0);
    }

    public StaticPosition getRelativePositionTarget(Snapshot combatant, Snapshot unused, long time) {
        DynamicPositionImpl vectorSum = new DynamicPositionImpl();
        Stopwatches.movementMethodGetRelativePositionTarget[this.getPersistenceId()].start();
        Iterator iterator = WaveInboundBank.singleton.iterator();
        if (iterator.hasNext()) {
            CombatWave wave = (CombatWave)iterator.next();
            double originDistanceToCombatant = wave.getDistance(combatant);
            Iterator firingAngleIterator = wave.getFiringAngleIterator();
            while (firingAngleIterator.hasNext()) {
                FiringAngle firingAngle = (FiringAngle)firingAngleIterator.next();
                StaticPositionImpl point = new StaticPositionImpl((StaticPosition)wave, new StaticVectorImpl(firingAngle.getFiringAngle(), originDistanceToCombatant));
                vectorSum.add(this.getFieldVector(point.getBearing(combatant), point.getDistance(combatant)));
            }
        }
        Stopwatches.movementMethodGetRelativePositionTarget[this.getPersistenceId()].stop();
        return vectorSum.getStaticPosition();
    }
}

