/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.movement.impl;

import pedersen.core.Snapshot;
import pedersen.debug.profiling.Stopwatches;
import pedersen.physics.DynamicPositionImpl;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticVectorImpl;
import pedersen.tactics.movement.MovementMethodBase;

public class MovementMethodTangoImpl
extends MovementMethodBase {
    private long periodLength = 48L;
    private long periodOffset = 0L;

    public MovementMethodTangoImpl() {
        super(7);
    }

    public MovementMethodTangoImpl(long period, long offset) {
        super(7);
        this.periodLength = period;
        this.periodOffset = offset;
    }

    public StaticPosition getRelativePositionTarget(Snapshot combatant, Snapshot target, long time) {
        DynamicPositionImpl vectorSum = new DynamicPositionImpl();
        Stopwatches.movementMethodGetRelativePositionTarget[this.getPersistenceId()].start();
        if (target != null) {
            double bearingToTarget = combatant.getBearing(target);
            double heading = 0.0;
            long periodIndex = (time + this.periodOffset) % this.periodLength;
            heading = periodIndex < this.periodLength / 2L ? bearingToTarget + 1.5707963267948966 : bearingToTarget - 1.5707963267948966;
            vectorSum.add(new StaticVectorImpl(heading, 8.0));
        }
        Stopwatches.movementMethodGetRelativePositionTarget[this.getPersistenceId()].stop();
        return vectorSum.getStaticPosition();
    }
}

