/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.targeting;

import pedersen.core.Snapshot;
import pedersen.debug.ProjectedIntercept;
import pedersen.debug.profiling.Stopwatches;
import pedersen.divination.CombatWave;
import pedersen.divination.FiringAngle;
import pedersen.misc.Arena;
import pedersen.physics.Projection;
import pedersen.physics.StaticPosition;
import pedersen.tactics.targeting.TargetingMethodBase;

public abstract class TargetingMethodBasePredictive
extends TargetingMethodBase {
    protected StaticPosition firingPosition = null;
    protected Snapshot target;
    protected Projection projectedTarget = null;

    public TargetingMethodBasePredictive(int newPersistenceId) {
        super(newPersistenceId);
    }

    protected abstract boolean init();

    protected abstract boolean project();

    public FiringAngle getFiringAngle(CombatWave wave, long delay) {
        FiringAngle firingAngle = null;
        Stopwatches.targetingMethodGetFiringAngle[this.getPersistenceId()].start();
        this.firingPosition = wave;
        this.target = wave.getTarget();
        this.projectedTarget = new Projection(this.target);
        double bulletVelocity = wave.getVelocity();
        if (this.init()) {
            int i = 0;
            while ((long)i < delay) {
                this.project();
                ++i;
            }
            int timeToTarget = 1;
            while (timeToTarget <= 100 && firingAngle == null && Arena.isVehicleCenterInBoundary(this.projectedTarget.getStaticPosition())) {
                double distanceToTarget = this.firingPosition.getDistance(this.projectedTarget.getStaticPosition());
                if (TargetingMethodBasePredictive.doesBulletIntersectTargetMidpoint(distanceToTarget, bulletVelocity, timeToTarget)) {
                    double bearingToTarget = this.firingPosition.getBearing(this.projectedTarget.getStaticPosition());
                    firingAngle = new FiringAngle(this, bearingToTarget);
                    firingAngle.setProjectedIntercept(new ProjectedIntercept(this.projectedTarget.getStaticPosition(), bearingToTarget, bulletVelocity));
                }
                this.project();
                ++timeToTarget;
            }
        }
        Stopwatches.targetingMethodGetFiringAngle[this.getPersistenceId()].stop();
        return firingAngle;
    }
}

