/*
 * Decompiled with CFR 0.152.
 */
package muf.utils;

import muf.utils.IndexMaker;

public class OccuranceCounter {
    protected IndexMaker indexMaker;
    protected double[] occurances;
    protected int highestOccuranceIndex;
    protected int stayCurrentFactor;
    protected int counter;

    public OccuranceCounter(IndexMaker indexMaker) {
        this(indexMaker, -1);
    }

    public OccuranceCounter(IndexMaker indexMaker, int n) {
        this.indexMaker = indexMaker;
        this.occurances = new double[indexMaker.getMaxIndex() + 1];
        this.highestOccuranceIndex = 0;
        this.stayCurrentFactor = n;
        this.counter = n;
    }

    public void setHighestOccuranceIndex(int n) {
        this.highestOccuranceIndex = n;
    }

    public void add(double d) {
        this.add(d, 1.0);
    }

    public void add(double d, double d2) {
        int n;
        int n2 = n = this.indexMaker.getIndex(d);
        this.occurances[n2] = this.occurances[n2] + d2;
        if (this.occurances[n] > this.occurances[this.highestOccuranceIndex]) {
            this.highestOccuranceIndex = n;
        }
        if (this.counter == 0) {
            int n3 = 0;
            while (n3 < this.occurances.length) {
                int n4 = n3++;
                this.occurances[n4] = this.occurances[n4] / 2.0;
            }
            this.counter = this.stayCurrentFactor;
        } else if (this.counter > 0) {
            --this.counter;
        }
    }

    public int getHighestOccuranceIndex() {
        return this.highestOccuranceIndex;
    }

    public double getHighestOccuranceValue() {
        return this.indexMaker.getValueByIndex(this.highestOccuranceIndex);
    }
}

