/*
 * Decompiled with CFR 0.152.
 */
package muf.utils;

import java.awt.geom.Point2D;

public class Rutils {
    public static final int DirLeft = -1;
    public static final int DirRight = 1;
    public static final int DirAhead = 1;
    public static final int DirBack = -1;
    public static final int DirUnknown = 0;
    public static final int GunTurningRate = 20;
    public static final int RadarTurningRate = 45;
    public static final int RobotSize = 36;
    public static final int HalfRobotSize = 18;
    public static final double RobotHitDamage = 0.6;
    public static final double MaxVelocity = 8.0;
    public static final double BulletMinPower = 0.1;
    public static final double BulletMaxPower = 3.0;
    public static final double BulletMinVelocity = Rutils.bulletVelocity(0.1);
    public static final double BulletMaxVelocity = Rutils.bulletVelocity(3.0);
    public static final double BulletMinDamage = Rutils.bulletDamage(0.1);
    public static final double BulletMaxDamage = Rutils.bulletDamage(3.0);

    public static double bulletVelocity(double d) {
        return 20.0 - 3.0 * d;
    }

    public static double bulletPowerFromVelocity(double d) {
        return (20.0 - d) / 3.0;
    }

    public static double turningRate(double d) {
        return 10.0 - 0.75 * d;
    }

    public static double wallHitDamage(double d) {
        double d2 = Math.abs(d) * 0.5 - 1.0;
        return d2 > 0.0 ? d2 : 0.0;
    }

    public static double bulletDamage(double d) {
        double d2 = 4.0 * d;
        if (d > 1.0) {
            d2 += 2.0 * (d - 1.0);
        }
        return d2;
    }

    public static double bulletPower(double d) {
        if (d < BulletMinDamage) {
            return 0.0;
        }
        if (d > BulletMaxDamage) {
            return 3.0;
        }
        if (d > 4.0) {
            return (d + 2.0) / 6.0;
        }
        return d / 4.0;
    }

    public static double bulletHitEnergyBack(double d) {
        return 3.0 * d;
    }

    public static double gunHeat(double d) {
        return 1.0 + d / 5.0;
    }

    public static double cos(double d) {
        return Math.cos(Math.toRadians(d));
    }

    public static double sin(double d) {
        return Math.sin(Math.toRadians(d));
    }

    public static double acos(double d) {
        return Math.toDegrees(Math.acos(d));
    }

    public static double asin(double d) {
        return Math.toDegrees(Math.asin(d));
    }

    public static double atan(double d) {
        return Math.toDegrees(Math.atan(d));
    }

    public static double atan2(double d, double d2) {
        return Math.toDegrees(Math.atan2(d, d2));
    }

    public static int sign(double d) {
        return d < 0.0 ? -1 : 1;
    }

    public static double pointsToAngle(Point2D point2D, Point2D point2D2) {
        return Rutils.pointsToAngle(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public static double pointsToAngle(double d, double d2, double d3, double d4) {
        double d5 = Point2D.distance(d, d2, d3, d4);
        double d6 = Rutils.asin((d3 - d) / d5);
        if (d4 - d2 >= 0.0) {
            return Rutils.normalAbsoluteAngle(d6);
        }
        return Rutils.normalAbsoluteAngle(180.0 - d6);
    }

    public static double normalRelativeAngle(double d) {
        double d2 = d % 360.0;
        if (d2 <= -180.0) {
            d2 += 360.0;
        } else if (d2 > 180.0) {
            d2 -= 360.0;
        }
        return d2;
    }

    public static double normalAbsoluteAngle(double d) {
        double d2 = d % 360.0;
        return d2 < 0.0 ? d2 + 360.0 : d2;
    }

    public static double random(double d, double d2) {
        return (d2 - d) * Math.random() + d;
    }

    public static double angleDiff(double d, double d2) {
        return Rutils.normalRelativeAngle(d - d2);
    }
}

