/*
 * Decompiled with CFR 0.152.
 */
package justin;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import justin.BulletInfo;
import justin.BulletInfoEnemy;
import justin.Enemy;
import justin.Gun;
import justin.HistoryLog;
import justin.Movement;
import justin.Radar;
import justin.SelectEnemy;
import justin.Special;
import justin.Targeting;
import justin.utils.DRUtils;
import justin.utils.FastTrig;
import justin.utils.KdTree;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public abstract class Module
extends AdvancedRobot {
    public Radar radar;
    public Targeting targeting;
    public Movement movement;
    public Gun gun;
    public SelectEnemy selectEnemy;
    public Vector<Special> specials = new Vector();
    public static final boolean enablePaint = true;
    public static final boolean enableWavesOnly = true;
    public static boolean paintWaves;
    public static boolean paintTargeting;
    public static boolean paintMovement;
    public static boolean paintRadar;
    public static boolean paintAll;
    public static boolean paintNone;
    public static int skippedTurns;
    private static int wallHits;
    private static int wallDamage;
    private static int[] finishes;
    public Enemy enemy = new Enemy();
    public static Enemy myData;
    public static Hashtable<String, Enemy> enemies;
    public Vector<BulletInfo> myBullets = new Vector();
    public Vector<BulletInfoEnemy> enemyBullets = new Vector();
    public static final boolean useNonSegmented = true;
    public static final int BINS = 41;
    public static boolean melee;
    public static double bw;
    public static double bh;
    public static Rectangle2D.Double bf;
    public static int allOthers;

    static {
        FastTrig.init();
        paintWaves = false;
        paintTargeting = false;
        paintMovement = false;
        paintRadar = false;
        paintAll = false;
        paintNone = true;
        skippedTurns = 0;
        wallHits = 0;
        wallDamage = 0;
        myData = new Enemy();
        enemies = new Hashtable();
        melee = true;
        allOthers = 10;
    }

    public void run() {
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        if (finishes == null) {
            finishes = new int[this.getOthers() + 1];
        }
        bw = this.getBattleFieldWidth();
        bh = this.getBattleFieldHeight();
        bf = new Rectangle2D.Double(17.6, 17.6, bw - 35.2, bh - 35.2);
        allOthers = this.getOthers();
        this.initialize();
        while (true) {
            melee = this.getOthers() > 1;
            this.updateMyData();
            BulletInfoEnemy.updateEnemyBullets(this);
            this.selectBehavior();
            this.executeBehavior();
        }
    }

    public static int getAllOthers() {
        return allOthers;
    }

    protected abstract void selectBehavior();

    protected abstract void initialize();

    private void executeBehavior() {
        this.selectEnemy.select();
        this.radar.scan();
        this.targeting.target();
        this.movement.move();
        Iterator<Special> i = this.specials.iterator();
        while (i.hasNext()) {
            i.next().doIt();
        }
        this.execute();
    }

    private void listenEvent(Event e) {
        this.selectEnemy.listen(e);
        this.radar.listen(e);
        this.targeting.listen(e);
        this.movement.listen(e);
        Iterator<Special> i = this.specials.iterator();
        while (i.hasNext()) {
            i.next().listen(e);
        }
    }

    private void listenInputEvent(InputEvent e) {
        if (this.selectEnemy != null) {
            this.selectEnemy.listenInput(e);
        }
        if (this.radar != null) {
            this.radar.listenInput(e);
        }
        if (this.targeting != null) {
            this.targeting.listenInput(e);
        }
        if (this.movement != null) {
            this.movement.listenInput(e);
        }
        for (Special special : this.specials) {
            if (special == null) continue;
            special.listenInput(e);
        }
    }

    public void activate(Special special) {
        if (!this.specials.contains(special)) {
            this.specials.add(special);
        }
    }

    public void deactivate(Special special) {
        this.specials.remove(special);
    }

    public void registerMyBullet(Bullet bullet, List<KdTree.Entry<HistoryLog>> list) {
        BulletInfo bulletInfo = new BulletInfo();
        bulletInfo.bullet = bullet;
        bulletInfo.targeting = this.targeting.getClass().getSimpleName();
        bulletInfo.timeFire = (int)this.getTime();
        bulletInfo.list = list;
        this.myBullets.add(bulletInfo);
    }

    public void updateMyBullets() {
        int i = 0;
        while (i < this.myBullets.size()) {
            BulletInfo b = this.myBullets.get(i);
            if (!b.bullet.isActive()) {
                this.myBullets.remove(i);
                --i;
            }
            ++i;
        }
    }

    public void updateMyData() {
        double dir;
        Module.myData.alive = true;
        Module.myData.name = this.getName();
        Module.myData.scanTime = this.getTime();
        Module.myData.deltaScanTime = 1.0;
        Module.myData.previousBearingRadians = 0.0;
        Module.myData.bearingRadians = 0.0;
        Module.myData.deltaHeadingRadians = Utils.normalRelativeAngle((double)(Module.myData.headingRadians - this.getHeadingRadians()));
        Module.myData.headingRadians = this.getHeadingRadians();
        Module.myData.velocity = this.getVelocity();
        double d = dir = Module.myData.velocity != 0.0 ? Math.signum(Module.myData.velocity) : Module.myData.direction;
        Module.myData.tSDC = Module.myData.direction == dir && Module.myData.deltaScanTime < 20.0 && Module.myData.round == (double)this.getRoundNum() ? (Module.myData.tSDC += 1.0) : 0.0;
        Module.myData.direction = dir;
        Module.myData.round = this.getRoundNum();
        Module.myData.correctedHeadingRadians = Module.myData.direction < 0.0 ? Utils.normalAbsoluteAngle((double)(this.getHeadingRadians() + Math.PI)) : this.getHeadingRadians();
        Module.myData.distance = 0.0;
        Module.myData.location = new Point2D.Double(this.getX(), this.getY());
        Module.myData.energy = this.getEnergy();
        Module.myData.scanTime = this.getTime();
        Module.myData.round = this.getRoundNum();
        Enemy myClosestBot = Enemy.getClosestBotTo(myData, this);
        Module.myData.cbName = myClosestBot.name;
        Module.myData.cbD = Module.myData.location.distance(myClosestBot.location);
        Module.myData.cbC = 0.0;
        Module.myData.timeAliveTogether += 1.0;
        HistoryLog historyLog = new HistoryLog();
        historyLog.name = Module.myData.name;
        historyLog.scanTime = this.getTime();
        historyLog.round = this.getRoundNum();
        historyLog.location = Module.myData.location;
        historyLog.correctedHeadingRadians = Module.myData.correctedHeadingRadians;
        historyLog.velocity = this.getVelocity();
        if (Module.myData.last != null) {
            Enemy.updateHistoryLog(historyLog, myData);
        } else {
            Module.myData.last = historyLog;
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Enemy oldData = enemies.get(e.getName());
        if (oldData == null) {
            oldData = new Enemy();
            oldData.gunTree1vrs1 = new KdTree.SqrEuclid<HistoryLog>(34, 30000);
            oldData.gunTreeMelee = new KdTree.SqrEuclid<HistoryLog>(34, 30000);
            oldData.enemyWaveTree1vrs1 = new KdTree.SqrEuclid<HistoryLog>(8, 30000);
            oldData.enemyWaveTreeMelee = new KdTree.SqrEuclid<HistoryLog>(7, 30000);
            oldData.surfStats1vrs1 = BulletInfoEnemy.getDefaultWave();
            oldData.surfStatsMelee = BulletInfoEnemy.getDefaultWave();
        }
        Enemy scanned = Enemy.update(oldData, e, this);
        enemies.put(e.getName(), scanned);
        BulletInfoEnemy.detection(scanned, e, this);
        this.listenEvent((Event)e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Enemy him = enemies.get(e.getBullet().getName());
        him.damageGiven += Rules.getBulletDamage((double)e.getBullet().getPower());
        him.timeLastBulletHit = e.getTime();
        if (melee) {
            him.bulletHitsMelee += 1.0;
        } else {
            him.bulletHits1v1 += 1.0;
        }
        if (!this.enemyBullets.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            BulletInfoEnemy hitWave = null;
            int x = 0;
            while (x < this.enemyBullets.size()) {
                BulletInfoEnemy ew = this.enemyBullets.get(x);
                if (Math.abs(ew.distanceTraveled - hitBulletLocation.distance(ew.fireLocation)) < 50.0 && Math.round(Rules.getBulletSpeed((double)e.getBullet().getPower()) * 10.0) == Math.round(ew.velocity * 10.0) && ew.fromName == e.getBullet().getName()) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                BulletInfoEnemy.logHit(hitWave, hitBulletLocation, 1.0, this);
                if (hitWave.melee) {
                    him.enemyWaveTreeMelee.addPoint(hitWave.DCdistanceLocation, hitWave.myInfo);
                } else {
                    him.enemyWaveTree1vrs1.addPoint(hitWave.DCdistanceLocation, hitWave.myInfo);
                }
                this.enemyBullets.remove(this.enemyBullets.lastIndexOf(hitWave));
                this.paintHitWave(hitWave);
            }
        }
        int x = 0;
        while (x < this.enemyBullets.size()) {
            BulletInfoEnemy ew = this.enemyBullets.get(x);
            if (ew.fromName == e.getBullet().getName()) {
                ew.surf = true;
                ew.DCWave = BulletInfoEnemy.getDCWave(him, ew, ew.myInfo, this);
                ew.combinedWave = DRUtils.smoothBins(DRUtils.sumArrays(ew.buffer, ew.DCWave), 2.0);
            }
            ++x;
        }
        this.listenEvent((Event)e);
    }

    public void onHitRobot(HitRobotEvent e) {
        this.listenEvent((Event)e);
    }

    public void onHitWall(HitWallEvent e) {
        this.listenEvent((Event)e);
    }

    public void onBulletHit(BulletHitEvent e) {
        Enemy him = enemies.get(e.getName());
        him.damageRecieved += Rules.getBulletDamage((double)e.getBullet().getPower());
        this.listenEvent((Event)e);
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (!this.enemyBullets.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getHitBullet().getX(), e.getHitBullet().getY());
            BulletInfoEnemy hitWave = null;
            BulletInfoEnemy ew = null;
            int x = 0;
            while (x < this.enemyBullets.size()) {
                ew = this.enemyBullets.get(x);
                if (ew.distanceTraveled - hitBulletLocation.distance(ew.fireLocation) < 50.0 && Math.abs(e.getHitBullet().getVelocity() - ew.velocity) < 0.006 && ew.fromName == e.getHitBullet().getName()) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                BulletInfoEnemy.logHit(hitWave, hitBulletLocation, 0.5, this);
                this.enemyBullets.remove(this.enemyBullets.lastIndexOf(hitWave));
            }
        }
        this.listenEvent((Event)e);
    }

    public void onBulletMissed(BulletMissedEvent e) {
        this.listenEvent((Event)e);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        Enemy him = enemies.get(e.getName());
        him.alive = false;
        if (him.name == this.enemy.name) {
            this.enemy = new Enemy();
        }
        this.selectEnemy.select();
        this.listenEvent((Event)e);
    }

    public void onWin(WinEvent e) {
        this.finishRound();
        this.listenEvent((Event)e);
    }

    public void onDeath(DeathEvent e) {
        this.finishRound();
        this.listenEvent((Event)e);
    }

    public void finishRound() {
        this.out.println();
        System.out.print("Finishes :");
        int n = this.getOthers();
        finishes[n] = finishes[n] + 1;
        int i = 0;
        while (i < finishes.length) {
            this.out.print(String.valueOf(finishes[i]) + " ");
            ++i;
        }
        this.out.println();
        System.out.println("Wall Damage Total :" + wallDamage);
        System.out.println("wall Hits Total :" + wallHits);
        System.out.println("Skipped Turn Total :" + skippedTurns);
        System.out.println(" -===  GunStats  ===-");
        System.out.println("  ");
        if (this.getRoundNum() == 35) {
            System.out.println(" I don't need a big gun, when I'm standing behind you.");
        }
        for (Enemy him : enemies.values()) {
            if (!him.alive) {
                him.alive = true;
            }
            him.timeLastBulletHit = 0L;
        }
        this.out.println();
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        System.out.println("Skipped Turn time:" + this.getTime() + " , skippedTurn total :" + ++skippedTurns);
        this.listenEvent((Event)e);
    }

    public void onKeyPressed(KeyEvent e) {
        char key = e.getKeyChar();
        if (key == 'w') {
            paintWaves = this.toggleButton(paintWaves);
        }
        if (key == 't') {
            paintTargeting = this.toggleButton(paintTargeting);
        }
        if (key == 'r') {
            paintRadar = this.toggleButton(paintRadar);
        }
        if (key == 'm') {
            paintMovement = this.toggleButton(paintMovement);
        }
        if (key == 'a') {
            this.allButtons(true);
        }
        if (key == 'n') {
            this.allButtons(false);
        }
        this.listenInputEvent(e);
    }

    public boolean toggleButton(boolean button) {
        return !button;
    }

    public void allButtons(boolean button) {
        if (button) {
            paintAll = true;
            paintNone = false;
        } else {
            paintAll = false;
            paintNone = true;
        }
        paintWaves = button;
        paintTargeting = button;
        paintMovement = button;
        paintRadar = button;
    }

    public void onKeyReleased(KeyEvent e) {
        this.listenInputEvent(e);
    }

    public void onMouseMoved(MouseEvent e) {
        this.listenInputEvent(e);
    }

    public void onMousePressed(MouseEvent e) {
        this.listenInputEvent(e);
    }

    public void onMouseReleased(MouseEvent e) {
        Rectangle2D.Double allButton = new Rectangle2D.Double(80.0, 0.0, 52.0, 30.0);
        Rectangle2D.Double noneButton = new Rectangle2D.Double(132.0, 0.0, 50.0, 30.0);
        Rectangle2D.Double wavesButton = new Rectangle2D.Double(190.0, 0.0, 100.0, 30.0);
        Rectangle2D.Double targetingButton = new Rectangle2D.Double(290.0, 0.0, 100.0, 30.0);
        Rectangle2D.Double movementButton = new Rectangle2D.Double(400.0, 0.0, 100.0, 30.0);
        Rectangle2D.Double radarButton = new Rectangle2D.Double(500.0, 0.0, 100.0, 30.0);
        Point2D.Double pt = new Point2D.Double(e.getPoint().x, e.getPoint().y);
        if (allButton.contains(pt)) {
            paintAll = this.toggleButton(paintAll);
            this.allButtons(paintAll);
        }
        if (noneButton.contains(pt)) {
            this.allButtons(false);
        }
        if (wavesButton.contains(pt)) {
            paintWaves = this.toggleButton(paintWaves);
        }
        if (targetingButton.contains(pt)) {
            paintTargeting = this.toggleButton(paintTargeting);
        }
        if (movementButton.contains(pt)) {
            paintMovement = this.toggleButton(paintMovement);
        }
        if (radarButton.contains(pt)) {
            paintRadar = this.toggleButton(paintRadar);
        }
        this.listenInputEvent(e);
    }

    public void onPaint(Graphics2D g) {
        if (this.getTime() < 10L) {
            return;
        }
        g.setColor(Color.white);
        g.drawString("  PAINT :    All / None", 20, 5);
        if (paintWaves) {
            BulletInfoEnemy.paintWaves(g, this);
            g.setColor(Color.red);
        } else {
            g.setColor(Color.gray);
        }
        g.drawString("  Waves", 200, 5);
        if (paintTargeting) {
            this.targeting.onPaint(g);
            g.setColor(Color.red);
        } else {
            g.setColor(Color.gray);
        }
        g.drawString("  Targeting", 300, 5);
        if (paintMovement) {
            this.movement.onPaint(g);
            g.setColor(Color.red);
        } else {
            g.setColor(Color.gray);
        }
        g.drawString("  Movement", 400, 5);
        if (paintRadar) {
            this.radar.onPaint(g);
            this.selectEnemy.onPaint(g);
            g.setColor(Color.red);
        } else {
            g.setColor(Color.gray);
        }
        g.drawString("  Radar", 500, 5);
    }

    public void paintHitWave(BulletInfoEnemy w) {
        Graphics2D g = this.getGraphics();
        g.setColor(Color.red);
        g.drawOval((int)(w.fireLocation.x - w.distanceTraveled - 1.0), (int)(w.fireLocation.y - w.distanceTraveled - 1.0), (int)(2.0 * (w.distanceTraveled + 2.0)), (int)(2.0 * (2.0 + w.distanceTraveled)));
    }
}

