/*
 * Decompiled with CFR 0.152.
 */
package eem.gun;

import eem.EvBot;
import eem.gun.baseGun;
import eem.misc.logger;
import eem.misc.physics;
import eem.target.InfoBot;
import eem.target.botStatPoint;
import java.awt.Color;
import java.awt.geom.Point2D;

public class circularGun
extends baseGun {
    public circularGun() {
        this.gunName = "circular";
        this.gunColor = new Color(0, 0, 255, 128);
    }

    public circularGun(EvBot evBot) {
        this();
        this.myBot = evBot;
        this.calcGunSettings();
    }

    @Override
    protected Point2D.Double calcTargetFuturePosition(Point2D.Double double_, double d, InfoBot infoBot) {
        Point2D.Double double_2 = this.findTargetHitPositionWithCircularPredictor(double_, d, infoBot);
        return double_2;
    }

    public Point2D.Double positionAtFutureTime(InfoBot infoBot, double d) {
        double d2;
        double d3;
        double d4;
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        double d5 = 0.0;
        botStatPoint botStatPoint2 = infoBot.getLast();
        botStatPoint botStatPoint3 = infoBot.getPrev();
        Point2D.Double double_2 = botStatPoint2.getVelocity();
        if (botStatPoint3 == null) {
            d5 = 0.0;
        } else {
            Point2D.Double double_3 = botStatPoint3.getVelocity();
            d4 = Math.atan2(double_2.y, double_2.x);
            d3 = Math.atan2(double_3.y, double_3.x);
            d2 = botStatPoint2.getTime() - botStatPoint3.getTime();
            d5 = (d4 - d3) / d2;
        }
        d4 = Math.cos(d5);
        d3 = Math.sin(d5);
        d2 = d - (double)infoBot.getLastSeenTime();
        double d6 = double_2.x;
        double d7 = double_2.y;
        double_.x = infoBot.getX();
        double_.y = infoBot.getY();
        int n = 0;
        while ((double)n < d2) {
            double d8 = d6 * d4 - d7 * d3;
            double d9 = d6 * d3 + d7 * d4;
            d6 = d8;
            d7 = d9;
            double_.x += d6;
            double_.y += d7;
            if (this.myBot._motion.shortestDist2wall(double_) < (double)(this.myBot.robotHalfSize - 1)) {
                double_.x -= d6;
                double_.y -= d7;
                break;
            }
            ++n;
        }
        return double_;
    }

    public Point2D.Double findTargetHitPositionWithCircularPredictor(Point2D.Double double_, double d, InfoBot infoBot) {
        Point2D.Double double_2 = new Point2D.Double(0.0, 0.0);
        double d2 = physics.bulletSpeed(d);
        int n = 10;
        logger.noise("Bullet speed " + d2);
        double_2 = this.positionAtFutureTime(infoBot, this.myBot.getTime());
        logger.noise("Estimated target position " + double_2.x + ", " + double_2.y);
        double d3 = double_2.distance(double_);
        double d4 = d3 / d2;
        double d5 = 0.0;
        for (int i = 0; Math.abs(d5 - d4) > 1.0 && i < n; ++i) {
            d5 = d4;
            double_2 = this.positionAtFutureTime(infoBot, (double)this.myBot.getTime() + d5);
            d3 = double_2.distance(double_);
            d4 = d3 / d2;
        }
        logger.noise("Predicted target position " + double_2.x + ", " + double_2.y);
        return double_2;
    }
}

