/*
 * Decompiled with CFR 0.152.
 */
package pbg;

import java.awt.Color;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RateControlRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class R2D2
extends RateControlRobot {
    int turnCounter;
    int turnDirection = 1;
    int count = 0;
    boolean peek;
    boolean movingForward;
    double moveAmount;
    double gunTurnAmt;
    String trackName;

    public void run() {
        this.setColors(Color.white, Color.white, Color.green);
        this.moveAmount = Math.max(this.getBattleFieldWidth(), this.getBattleFieldHeight());
        this.turnCounter = 0;
        this.setGunRotationRate(15.0);
        while (true) {
            if (this.turnCounter % 64 == 0) {
                this.setTurnRate(8.0);
                this.setVelocityRate(9.0);
            }
            if (this.turnCounter % 64 == 32) {
                this.setVelocityRate(-5.0);
            }
            ++this.turnCounter;
            this.peek = false;
            this.execute();
            this.peek = true;
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (this.trackName != null) {
            e.getName().equals(this.trackName);
        }
        if (this.trackName == null) {
            this.trackName = e.getName();
            this.out.println("Tracking " + this.trackName);
        }
        this.count = 0;
        double absoluteBearing = this.getHeading() + e.getBearing();
        double bearingFromGun = Utils.normalRelativeAngleDegrees((double)(absoluteBearing - this.getGunHeading()));
        if (Math.abs(bearingFromGun) <= 17.0) {
            this.turnGunRight(bearingFromGun);
            if (this.getGunHeat() == 0.0) {
                this.fire(Math.min(3.0 - Math.abs(bearingFromGun), this.getEnergy() - 0.75));
            }
        } else {
            this.turnGunLeft(bearingFromGun);
        }
        if (bearingFromGun == 0.0) {
            this.fire(Math.min(3.0 - Math.abs(bearingFromGun), this.getEnergy() - 2.0));
        }
    }

    public void reverseDirection() {
        if (this.movingForward) {
            this.setBack(20.0);
            this.movingForward = false;
        } else {
            this.setAhead(30.0);
            this.movingForward = true;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (e.getBearing() > -90.0 && e.getBearing() < 90.0) {
            this.turnGunRight(e.getBearing());
        } else {
            this.turnGunLeft(e.getBearing());
        }
    }

    public void onHitRobot(HitRobotEvent e) {
        if (this.trackName != null && !this.trackName.equals(e.getName())) {
            this.out.println("Tracking " + e.getName() + " due to collision");
        }
        this.trackName = e.getName();
        this.gunTurnAmt = Utils.normalRelativeAngleDegrees((double)(e.getBearing() + (this.getHeading() - this.getRadarHeading())));
        this.turnGunRight(this.gunTurnAmt);
        if (e.getBearing() > -90.0 && e.getBearing() < 90.0) {
            this.back(70.0);
        } else {
            this.ahead(90.0);
        }
    }

    public void onHitWall(HitWallEvent e) {
        this.setVelocityRate(-7.0 * this.getVelocityRate());
        if (e.getBearing() > -90.0 && e.getBearing() < 90.0) {
            this.back(30.0);
        } else {
            this.ahead(20.0);
        }
    }
}

