/*
 * Decompiled with CFR 0.152.
 */
package syl.core;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import syl.core.BaseRobot;
import syl.core.Enemy;
import syl.core.EnemyListener;
import syl.core.RobotListenerAdapter;

public class EnemyMap
extends RobotListenerAdapter {
    private ArrayList listeners = new ArrayList();
    private Hashtable enemies = new Hashtable();

    public Enemy getEnemy(String enemyName) {
        return (Enemy)this.enemies.get(enemyName);
    }

    public int getNumberOfEnemies() {
        return this.enemies.size();
    }

    public Enumeration getAllEnemies() {
        return this.enemies.elements();
    }

    public void onRobotDeath(BaseRobot robot, RobotDeathEvent event) {
        String enemyName = event.getName();
        Enemy enemy = this.getEnemy(enemyName);
        this.enemies.remove(enemyName);
        int i = 0;
        while (i < this.listeners.size()) {
            ((EnemyListener)this.listeners.get(i)).onEnemyDeath(enemy);
            ++i;
        }
    }

    public void onScannedRobot(BaseRobot robot, ScannedRobotEvent event) {
        String enemyName = event.getName();
        Enemy enemy = this.getEnemy(enemyName);
        if (enemy == null) {
            enemy = new Enemy(enemyName);
            this.enemies.put(enemyName, enemy);
        }
        enemy.update(robot, event.getDistance(), event.getEnergy(), event.getHeading(), event.getBearing(), event.getVelocity(), robot.getTime());
        int i = 0;
        while (i < this.listeners.size()) {
            ((EnemyListener)this.listeners.get(i)).onEnemyChange(enemy);
            ++i;
        }
    }

    public void addEnemyListener(EnemyListener enemyListener) {
        this.listeners.add(enemyListener);
    }

    public void removeEnemyListener(EnemyListener enemyListener) {
        ((AbstractCollection)this.listeners).remove(enemyListener);
    }
}

