/*
 * Decompiled with CFR 0.152.
 */
package syl.core;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Hashtable;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import syl.core.BaseRobot;
import syl.core.Enemy;
import syl.core.EnemyFireEvent;
import syl.core.EnemyListener;
import syl.core.FireScannerListener;

public class FireScanner
implements EnemyListener {
    private Hashtable energyChangeEnemies = new Hashtable();
    private ArrayList listeners = new ArrayList();

    public void onEnemyChange(Enemy enemy) {
        EnemyFireEvent event;
        String enemyName = enemy.getName();
        double energy = enemy.getEnergy();
        EnergyChangeEnemy energyChangeEnemy = (EnergyChangeEnemy)this.energyChangeEnemies.get(enemyName);
        if (energyChangeEnemy == null) {
            energyChangeEnemy = new EnergyChangeEnemy(enemyName, energy);
            this.energyChangeEnemies.put(enemyName, energyChangeEnemy);
        }
        if ((event = energyChangeEnemy.update(energy)) != null) {
            event.setEnemy(enemy);
            int i = 0;
            while (i < this.listeners.size()) {
                ((FireScannerListener)this.listeners.get(i)).onEnemyFire(event);
                ++i;
            }
        }
    }

    public void onEnemyDeath(Enemy enemy) {
        this.energyChangeEnemies.remove(enemy.getName());
    }

    public void onHitByBullet(BaseRobot robot, HitByBulletEvent event) {
        String enemyName = event.getName();
        double power = event.getBullet().getPower();
        double energyGain = 3.0 * power;
        EnergyChangeEnemy energyChangeEnemy = (EnergyChangeEnemy)this.energyChangeEnemies.get(enemyName);
        if (energyChangeEnemy != null) {
            energyChangeEnemy.addToExpectedEnergy(energyGain);
        }
    }

    public void onBulletHit(BaseRobot robot, BulletHitEvent event) {
        EnergyChangeEnemy energyChangeEnemy;
        String enemyName = event.getName();
        double power = event.getBullet().getPower();
        double energyLoss = 4.0 * power;
        if (power > 1.0) {
            energyLoss += 2.0 * (power - 1.0);
        }
        if ((energyChangeEnemy = (EnergyChangeEnemy)this.energyChangeEnemies.get(enemyName)) != null) {
            energyChangeEnemy.substractFromExptectedEnergy(energyLoss);
        }
    }

    public void onRobotDeath(BaseRobot robot, RobotDeathEvent event) {
    }

    public void addFireScannerListener(FireScannerListener listener) {
        this.listeners.add(listener);
    }

    public void removeFireScannerListener(FireScannerListener listener) {
        ((AbstractCollection)this.listeners).remove(listener);
    }

    class EnergyChangeEnemy {
        private static final double MIN_ENERGY_DROP = 0.1;
        private static final double MAX_ENERGY_DROP = 3.0;
        private String name;
        private double energy;
        private double expectedEnergy;

        public EnergyChangeEnemy(String name, double energy) {
            this.name = name;
            this.energy = energy;
        }

        public EnemyFireEvent update(double newEnergy) {
            double difference = this.expectedEnergy - newEnergy;
            this.expectedEnergy = newEnergy;
            this.energy = newEnergy;
            if (difference >= 0.1 && difference <= 3.0) {
                return new EnemyFireEvent(difference);
            }
            return null;
        }

        public void addToExpectedEnergy(double energyGain) {
            this.expectedEnergy += energyGain;
        }

        public void substractFromExptectedEnergy(double energyLoss) {
            this.expectedEnergy -= energyLoss;
        }
    }
}

