/*
 * Decompiled with CFR 0.152.
 */
package syl.movement.gravity;

import java.util.Enumeration;
import java.util.Hashtable;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import syl.core.BaseRobot;
import syl.movement.GravityMovementStrategy;
import syl.movement.gravity.GravityMovementFeature;
import syl.movement.gravity.GravityPoint;
import syl.util.Angle;
import syl.util.Coordinate;

public class StrafeGravity
extends GravityMovementFeature {
    private GravityMovementStrategy strategy;
    private Hashtable enemyCoordinates = new Hashtable();
    private int switchCount;
    private static final String EVASIVE_POINT = "evasivePoint";
    private static final double EVASIVE_DISTANCE = 250.0;
    private static final double EVASIVE_RANGE = 2.0;
    private static int switchTreshold = 10;
    private static double evasivePower = -1000.0;

    public StrafeGravity(BaseRobot robot, GravityMovementStrategy strategy) {
        this.strategy = strategy;
        strategy.addFeature(this);
        robot.addRobotListener(this);
        GravityPoint evasivePoint = new GravityPoint(new Coordinate(50.0, 50.0), evasivePower, 2.0);
        strategy.putGravityPoint(EVASIVE_POINT, evasivePoint);
    }

    public void updateGravityPoints(BaseRobot robot) {
        ++this.switchCount;
        if (this.switchCount > switchTreshold) {
            switchTreshold = new Double(Math.random() * 7.0).intValue() + 5;
            this.switchCount = 0;
            int modifier = Math.random() < 0.5 ? -1 : 1;
            evasivePower *= (double)modifier;
        }
        GravityPoint evasivePoint = this.strategy.getGravityPoint(EVASIVE_POINT);
        Coordinate robotCoordinate = robot.getCoordinate();
        double angle = 0.0;
        Enumeration enumeration = this.enemyCoordinates.elements();
        int numberOfEnemies = 0;
        while (enumeration.hasMoreElements()) {
            Coordinate enemyCoordinate = (Coordinate)enumeration.nextElement();
            double enemyAngle = robotCoordinate.getAngle(enemyCoordinate);
            if (Math.abs(enemyAngle) > Math.abs(Angle.toOppositeAngle(enemyAngle))) {
                enemyAngle = Angle.toOppositeAngle(enemyAngle);
            }
            angle += enemyAngle;
            ++numberOfEnemies;
        }
        if (numberOfEnemies > 0) {
            angle /= (double)numberOfEnemies;
            angle += 90.0;
            while (angle > 180.0) {
                angle -= 180.0;
            }
        }
        Coordinate targetCoordinate = robotCoordinate.getCoordinate(250.0, angle);
        evasivePoint.setCoordinate(targetCoordinate);
        evasivePoint.setPower(evasivePower);
    }

    public void onScannedRobot(BaseRobot robot, ScannedRobotEvent event) {
        String enemyName = event.getName();
        Coordinate enemyCoordinate = Coordinate.getCoordinate(robot.getX(), robot.getY(), event.getDistance(), robot.getEnemyAngle(event.getBearing()));
        this.enemyCoordinates.put(enemyName, enemyCoordinate);
    }

    public void onRobotDeath(BaseRobot robot, RobotDeathEvent event) {
        String enemyName = event.getName();
        this.enemyCoordinates.remove(enemyName);
    }
}

