/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws.data;

public class KNNParms {
    private SelectBy selectBy = SelectBy.KNN;
    private int minK = 1;
    private int maxK = 20;
    private double kPercentOfTotal = 0.12;
    private double visitKPercentOfHitK = 10.0;
    private double[] rangeSpan;
    private int knnWhenSelectionEmpty = 1;
    double visitDistance;

    public KNNParms(int minK, int maxK, double kPercentOfTotal) {
        this.minK = minK;
        this.maxK = maxK;
        this.kPercentOfTotal = kPercentOfTotal;
    }

    public KNNParms(int rangeDimensions) {
        this.selectBy = SelectBy.RANGE;
        this.rangeSpan = new double[rangeDimensions];
    }

    public KNNParms(double ... rangeSpan) {
        this.selectBy = SelectBy.RANGE;
        this.rangeSpan = rangeSpan;
    }

    public void setSelectBy(SelectBy selectBy) {
        this.selectBy = selectBy;
    }

    public boolean isSelectByKNN() {
        return this.selectBy == SelectBy.KNN;
    }

    public boolean isSelectByRange() {
        return this.selectBy == SelectBy.RANGE;
    }

    public boolean isSelectByHitsWithinKNNVisits() {
        return this.selectBy == SelectBy.HITS_WITHIN_KNN_VISITS;
    }

    public double[] getRangeSpan() {
        return this.rangeSpan;
    }

    public void setRangeSpan(double[] rangeSpan) {
        this.rangeSpan = rangeSpan;
    }

    public int getKnnWhenSelectionEmpty() {
        return this.knnWhenSelectionEmpty;
    }

    public void setKnnWhenSelectionEmpty(int knnWhenSelectionEmpty) {
        this.knnWhenSelectionEmpty = knnWhenSelectionEmpty;
    }

    public void setVisitKPercentOfHitK(double visitKPercentOfHitK) {
        this.visitKPercentOfHitK = visitKPercentOfHitK;
    }

    public int getK(int totalPoints) {
        int hitK = (int)Math.round(this.kPercentOfTotal * (double)totalPoints);
        return Math.max(Math.min(hitK, this.maxK), this.minK);
    }

    public int getVisitKAsPercentOfHitK(int totalHits) {
        int hitK = this.getK(totalHits);
        return (int)Math.round(this.visitKPercentOfHitK * (double)hitK);
    }

    public static enum SelectBy {
        KNN,
        RANGE,
        HITS_WITHIN_KNN_VISITS;

    }
}

