/*
 * Decompiled with CFR 0.152.
 */
package justin;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.List;
import justin.DCWaveDistance1v1;
import justin.DCWaveDistanceMelee;
import justin.Enemy;
import justin.HistoryLog;
import justin.Module;
import justin.utils.DRUtils;
import justin.utils.KdTree;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class BulletInfoEnemy {
    public static final int SIMILAR_WAVES_SIZE = 25;
    public static final double ROLLING_DEPTH = 20.0;
    public static final double SMOOTH_BIN_SPEED = 24.0;
    public static final double BOT_WIDTH = 18.0;
    public static double flattenerValue = 0.0;
    public static final double UPDATE_MISSED_BULLET = 20.0;
    public static final double PAINT_GRAPH_SIZE = 750.0;
    public String fromName;
    public boolean surf = true;
    public Point2D.Double fireLocation;
    public Point2D.Double targetLocation;
    public double velocity;
    public double power;
    public double distanceTraveled;
    public double myLateralDir;
    public double[] buffer;
    public double surfWeight;
    public double[] DCWave;
    public double[] DCdistanceLocation = null;
    public HistoryLog myInfo = null;
    public boolean melee;
    public double hotHeading;
    public double linearHeading;
    public double circularHeading;
    public double guessFactorHeading;
    public double antiSurfHeading;

    public static void detection(Enemy scan, ScannedRobotEvent e, Module bot) {
        if (scan.deltaEnergy <= 3.01 && scan.deltaEnergy >= 0.1 && Math.abs(Math.abs(scan.previousVelocity) - Math.abs(scan.velocity)) <= scan.deltaScanTime * 2.0 && scan.deltaScanTime <= 8.0 && bot.getTime() > 3L) {
            BulletInfoEnemy enemyBullet = new BulletInfoEnemy();
            enemyBullet.surf = scan.distance < scan.cbD * 1.3 || scan.scanTime - (double)scan.timeLastBulletHit < (double)Math.min(45L, bot.getTime()) || bot.getOthers() < 2 || bot.enemyBullets.size() == 0 && scan.distance <= bot.myData.cbD * 1.35;
            enemyBullet.fromName = scan.name;
            enemyBullet.power = scan.deltaEnergy;
            enemyBullet.distanceTraveled = enemyBullet.velocity = Rules.getBulletSpeed((double)enemyBullet.power);
            if (Module.melee) {
                scan.bulletShotsMelee += 1.0;
            } else {
                scan.bulletShots1v1 += 1.0;
            }
            HistoryLog info = scan.last;
            HistoryLog myInfo = bot.myData.last;
            double timeInHistory = Math.ceil(scan.deltaScanTime / 2.0);
            double i = 0.0;
            while (i < timeInHistory) {
                if (info.previous == null) break;
                info = info.previous;
                myInfo = myInfo.previous;
                i += 1.0;
            }
            enemyBullet.fireLocation = info.location;
            enemyBullet.targetLocation = myInfo.location;
            enemyBullet.distanceTraveled = enemyBullet.velocity * (timeInHistory + 0.0);
            enemyBullet.hotHeading = DRUtils.absoluteBearing(enemyBullet.fireLocation, enemyBullet.targetLocation);
            double rotation = myInfo.previous == null ? 1.0 : Utils.normalRelativeAngle((double)(enemyBullet.hotHeading - DRUtils.absoluteBearing(enemyBullet.fireLocation, myInfo.previous.location)));
            enemyBullet.myLateralDir = rotation >= 0.0 ? 1 : -1;
            enemyBullet.buffer = BulletInfoEnemy.getDefaultWave();
            enemyBullet.buffer = Module.melee ? scan.surfStatsMelee : scan.surfStats1vrs1;
            enemyBullet.circularHeading = BulletInfoEnemy.getEnemiesCircularTargeting(scan, bot, enemyBullet.power, bot.myData.deltaHeadingRadians);
            enemyBullet.guessFactorHeading = BulletInfoEnemy.getAngleToBin(BulletInfoEnemy.getBinIndexWithHighestValue(enemyBullet.buffer), enemyBullet);
            enemyBullet.antiSurfHeading = BulletInfoEnemy.getAngleToBin(BulletInfoEnemy.getBinIndexWithLowestValue(enemyBullet.buffer), enemyBullet);
            enemyBullet.surfWeight = (1.0 + (1.0 - Math.min(scan.distance, 1000.0) / 1000.0) * ((scan.cbC + 2.0) / (double)(bot.getOthers() + 1)) * (double)(11 - bot.getOthers())) / 2.0;
            enemyBullet.myInfo = myInfo;
            if (Module.melee) {
                enemyBullet.melee = true;
                enemyBullet.DCdistanceLocation = DCWaveDistanceMelee.get(bot.myData, scan, bot);
            } else {
                enemyBullet.melee = false;
                enemyBullet.DCdistanceLocation = DCWaveDistance1v1.get(bot.myData, scan, bot);
            }
            enemyBullet.DCWave = BulletInfoEnemy.getDCWave(scan, enemyBullet, myInfo, bot);
            bot.enemyBullets.add(enemyBullet);
        }
    }

    public static void updateEnemyBullets(Module bot) {
        int i = 0;
        while (i < bot.enemyBullets.size()) {
            BulletInfoEnemy bullet = bot.enemyBullets.get(i);
            bullet.distanceTraveled += bullet.velocity;
            if (bullet.distanceTraveled > bot.myData.location.distance(bullet.fireLocation) + 20.0) {
                BulletInfoEnemy.logHit(bullet, bot.myData.location, Double.MIN_VALUE, bot);
                Enemy him = Module.enemies.get(bullet.fromName);
                bot.enemyBullets.remove(i);
                --i;
            }
            ++i;
        }
    }

    public static void logHit(BulletInfoEnemy ew, Point2D.Double targetLocation, double value, Module bot) {
        if (value == 0.0 && !ew.surf) {
            return;
        }
        Enemy enemyWhoShot = Module.enemies.get(ew.fromName);
        double index = BulletInfoEnemy.getBinIndex(ew, targetLocation);
        if (value != Double.NaN) {
            double angle = BulletInfoEnemy.getAngleToBin(index, ew);
            double tolerence = Math.atan(18.0 / ew.distanceTraveled);
            if (Math.abs(angle - ew.guessFactorHeading) < tolerence) {
                enemyWhoShot.TMguessFactor += 1.0;
            }
            if (Math.abs(angle - ew.hotHeading) < tolerence) {
                enemyWhoShot.TMheadOn += 1.0;
            }
            if (Math.abs(angle - ew.circularHeading) < tolerence) {
                enemyWhoShot.TMcircular += 1.0;
            }
            if (Math.abs(angle - ew.linearHeading) < tolerence) {
                enemyWhoShot.TMlinear += 1.0;
            }
            if (Math.abs(angle - ew.antiSurfHeading) < tolerence) {
                enemyWhoShot.TMantiSurf += 1.0;
            }
        } else {
            value = flattenerValue;
        }
        int x = 0;
        while (x < 41) {
            double newEntry = 0.0;
            if (Math.abs((double)x - index) < 4.0) {
                newEntry = 1.0;
            }
            ew.buffer[x] = DRUtils.rollingAverage(ew.buffer[x], newEntry * value, 20.0);
            ++x;
        }
        x = 1;
        while (x < 40) {
            ew.buffer[x] = DRUtils.rollingAverage(ew.buffer[x], ew.buffer[x + 1], 24.0);
            ew.buffer[40 - x] = DRUtils.rollingAverage(ew.buffer[40 - x], ew.buffer[40 - x - 1], 24.0);
            ++x;
        }
    }

    public static Point2D.Double getBinIndexRange(BulletInfoEnemy ew, Point2D.Double targetLocation) {
        double offsetAngleMax = DRUtils.absoluteBearing(ew.fireLocation, targetLocation) - ew.hotHeading + Math.atan(22.0 / ew.fireLocation.distance(targetLocation));
        double offsetAngleMin = DRUtils.absoluteBearing(ew.fireLocation, targetLocation) - ew.hotHeading - Math.atan(22.0 / ew.fireLocation.distance(targetLocation));
        double factorMax = Utils.normalRelativeAngle((double)offsetAngleMax) / (BulletInfoEnemy.maxEscapeAngle(ew.velocity) * ew.myLateralDir);
        double factorMin = Utils.normalRelativeAngle((double)offsetAngleMin) / (BulletInfoEnemy.maxEscapeAngle(ew.velocity) * ew.myLateralDir);
        return new Point2D.Double((int)(factorMax * 20.0) + 20, (int)(factorMin * 20.0) + 20);
    }

    public static int getBinIndex(BulletInfoEnemy ew, Point2D.Double targetLocation) {
        double offsetAngle = DRUtils.absoluteBearing(ew.fireLocation, targetLocation) - ew.hotHeading;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / (BulletInfoEnemy.maxEscapeAngle(ew.velocity) * ew.myLateralDir);
        return (int)DRUtils.limit(0.0, factor * 20.0 + 20.0, 40.0);
    }

    public static int getBinIndexWithLowestValue(double[] stats) {
        double smallestValue = Double.POSITIVE_INFINITY;
        double binValue = Double.POSITIVE_INFINITY;
        int binIndex = 20;
        int x = 0;
        while (x < 41) {
            binValue = stats[x];
            if (binValue < smallestValue) {
                binIndex = x;
                smallestValue = binValue;
            }
            ++x;
        }
        return binIndex;
    }

    public static int getBinIndexWithHighestValue(double[] stats) {
        double highestValue = Double.NEGATIVE_INFINITY;
        double binValue = Double.NEGATIVE_INFINITY;
        int binIndex = 20;
        int x = 0;
        while (x < 41) {
            binValue = stats[x];
            if (binValue > highestValue) {
                binIndex = x;
                highestValue = binValue;
            }
            ++x;
        }
        return binIndex;
    }

    public static double getAngleToBin(double bin, BulletInfoEnemy b) {
        double factor = (bin - 20.0) / 20.0;
        double bearingOffset = b.myLateralDir * (factor * BulletInfoEnemy.maxEscapeAngle(b.velocity));
        return b.hotHeading + bearingOffset;
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static double[] getDefaultWave() {
        double[] wave = new double[41];
        double index = 20.0;
        int x = 0;
        while (x < 41) {
            double newEntry = 0.0;
            if (Math.abs((double)x - index) < 4.0) {
                newEntry = 0.05;
            }
            int n = x++;
            wave[n] = wave[n] + newEntry;
        }
        int j = 1;
        while (j < 5) {
            int x2 = 1;
            while (x2 < 40) {
                wave[x2] = DRUtils.rollingAverage(wave[x2], wave[x2 + 1], 8.0);
                wave[40 - x2] = DRUtils.rollingAverage(wave[40 - x2], wave[40 - x2 - 1], 4.0);
                ++x2;
            }
            ++j;
        }
        return wave;
    }

    public static double[] getZeroWave() {
        double[] wave = new double[41];
        int x = 0;
        while (x < 41) {
            wave[x] = 0.0;
            ++x;
        }
        return wave;
    }

    public static BulletInfoEnemy getClosestSurfableWave(Module bot) {
        double closestDistance = Double.POSITIVE_INFINITY;
        BulletInfoEnemy surfWave = null;
        int x = 0;
        while (x < bot.enemyBullets.size()) {
            double distance;
            BulletInfoEnemy ew = bot.enemyBullets.get(x);
            if (ew.surf && (distance = bot.myData.location.distance(ew.fireLocation) - ew.distanceTraveled) > ew.velocity && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
            ++x;
        }
        return surfWave;
    }

    public static BulletInfoEnemy getClosestSurfableWave2(BulletInfoEnemy wave, Module bot) {
        double closestDistance = Double.POSITIVE_INFINITY;
        BulletInfoEnemy surfWave = null;
        int x = 0;
        while (x < bot.enemyBullets.size()) {
            double distance;
            BulletInfoEnemy ew = bot.enemyBullets.get(x);
            if (ew.surf && (distance = bot.myData.location.distance(ew.fireLocation) - ew.distanceTraveled) > ew.velocity && distance < closestDistance && ew != wave) {
                surfWave = ew;
                closestDistance = distance;
            }
            ++x;
        }
        return surfWave;
    }

    public static void paintWaves(Graphics2D g, Module bot) {
        int x = 0;
        while (x < bot.enemyBullets.size()) {
            BulletInfoEnemy b = bot.enemyBullets.get(x);
            BulletInfoEnemy.paintSimpleWave(b, g, bot);
            ++x;
        }
        BulletInfoEnemy w = BulletInfoEnemy.getClosestSurfableWave(bot);
        BulletInfoEnemy w2 = BulletInfoEnemy.getClosestSurfableWave2(w, bot);
        if (w != null) {
            BulletInfoEnemy.paintGraph(w, w.buffer, g, 30, 55);
        }
        if (w != null) {
            BulletInfoEnemy.paintBins2(w, w.DCWave, g);
        }
        if (w2 != null) {
            BulletInfoEnemy.paintBins2(w2, w2.DCWave, g);
        }
        if (w != null) {
            BulletInfoEnemy.paintGraph(w, w.DCWave, g, 300, 55);
        }
    }

    public static boolean paintGraph(BulletInfoEnemy w, double[] stats, Graphics2D g, int X, int Y) {
        String m;
        int moveOver = 0;
        g.setColor(new Color(250, 250, 250, 200));
        String string = m = Module.melee ? "   melee" : "   1vrs1";
        if (w != null) {
            g.drawString(String.valueOf(w.fromName) + m, X, Y - 20);
        } else {
            g.drawString("    No Waves.", X, Y - 20);
        }
        int i = 0;
        while (i < 41) {
            Color c;
            Color color = c = i > 20 ? new Color(51, 204, 0, 200) : new Color(204, 0, 0, 200);
            if (i == 20) {
                c = new Color(250, 250, 0, 200);
            }
            g.setColor(c);
            if (w != null) {
                g.drawLine(X + i * 3, Y, X + i * 3, (int)((double)(Y + 2) + stats[i] * 750.0));
            } else {
                g.drawLine(X + i * 3, Y, X + i * 3, Y + 2);
            }
            moveOver += 5;
            ++i;
        }
        return true;
    }

    public static boolean paintBins(BulletInfoEnemy w, double[] stats, Graphics2D g) {
        if (w == null) {
            return false;
        }
        double maxValue = Double.NEGATIVE_INFINITY;
        double minValue = Double.POSITIVE_INFINITY;
        int j = 0;
        while (j < 41) {
            if (stats[j] < minValue) {
                minValue = stats[j];
            }
            if (stats[j] > maxValue) {
                maxValue = stats[j];
            }
            ++j;
        }
        if (!(maxValue > 0.0)) {
            maxValue = 1.0;
        }
        int i = 0;
        while (i < 41) {
            double ang = BulletInfoEnemy.getAngleToBin(i, w);
            Point2D.Double pt = DRUtils.project(w.fireLocation, ang, w.distanceTraveled - 14.0);
            g.setColor(DRUtils.calculateNewColor(Color.red, Color.blue, (stats[i] - minValue) / (maxValue - minValue)));
            g.fillOval((int)pt.x - 3, (int)pt.y - 3, 6, 6);
            ++i;
        }
        return true;
    }

    public static boolean paintBins2(BulletInfoEnemy w, double[] stats, Graphics2D g) {
        if (w == null) {
            return false;
        }
        double maxValue = Double.NEGATIVE_INFINITY;
        double minValue = Double.POSITIVE_INFINITY;
        int j = 0;
        while (j < 41) {
            if (stats[j] < minValue) {
                minValue = stats[j];
            }
            if (stats[j] > maxValue) {
                maxValue = stats[j];
            }
            ++j;
        }
        if (!(maxValue > 0.0)) {
            maxValue = 1.0;
        }
        int i = 0;
        while (i < 41) {
            double ang = BulletInfoEnemy.getAngleToBin(i, w);
            Point2D.Double pt = DRUtils.project(w.fireLocation, ang, w.distanceTraveled - 4.0);
            g.setColor(DRUtils.calculateNewColor(Color.red, Color.blue, (stats[i] - minValue) / (maxValue - minValue)));
            g.fillOval((int)pt.x - 3, (int)pt.y - 3, 6, 6);
            ++i;
        }
        return true;
    }

    public static void paintSimpleWave(BulletInfoEnemy w, Graphics2D g, Module bot) {
        if (w == null) {
            return;
        }
        g.setColor(new Color(250, 250, 250, 45));
        g.drawOval((int)(w.fireLocation.x - w.distanceTraveled), (int)(w.fireLocation.y - w.distanceTraveled), (int)(2.0 * w.distanceTraveled), (int)(2.0 * w.distanceTraveled));
    }

    public static double getEnemiesLinearTargeting(Enemy e, Module bot, double bulletPower) {
        return BulletInfoEnemy.getEnemiesCircularTargeting(e, bot, bulletPower, 0.0);
    }

    public static double getEnemiesCircularTargeting(Enemy e, Module bot, double bulletPower, double targetDeltaHeading) {
        Point2D.Double enemyNextLocation = DRUtils.nextLocation(e.location, e.velocity, e.headingRadians);
        double myHeading = bot.myData.headingRadians;
        double myVelocity = bot.myData.velocity;
        double deltaTime = 0.0;
        Point2D.Double predictedLocation = bot.myData.location;
        while ((deltaTime += 1.0) * Rules.getBulletSpeed((double)bulletPower) < enemyNextLocation.distance(predictedLocation)) {
            predictedLocation = DRUtils.project(predictedLocation, myHeading, myVelocity);
            myHeading -= targetDeltaHeading;
            if (!Module.bf.contains(predictedLocation)) break;
        }
        double theta = DRUtils.absoluteBearing(enemyNextLocation, predictedLocation);
        return theta;
    }

    public static Point2D.Double predictPosition(BulletInfoEnemy surfWave, double direction, Module bot) {
        Point2D.Double predictedPosition = bot.myData.location;
        double predictedVelocity = bot.getVelocity();
        double predictedHeading = bot.getHeadingRadians();
        int counter = 0;
        boolean intercepted = false;
        do {
            double moveAngle = BulletInfoEnemy.wallSmoothing(predictedPosition, DRUtils.absoluteBearing(surfWave.fireLocation, predictedPosition) + direction * 1.5707963267948966, direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + DRUtils.limit(-maxTurning, moveAngle, maxTurning)));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
            predictedVelocity = DRUtils.limit(-8.0, predictedVelocity, 8.0);
            predictedPosition = DRUtils.project(predictedPosition, predictedHeading, predictedVelocity);
            ++counter;
            if (!(predictedPosition.distance(surfWave.fireLocation) < surfWave.distanceTraveled + (double)counter * surfWave.velocity + surfWave.velocity)) continue;
            intercepted = true;
        } while (!intercepted && counter < 500);
        return predictedPosition;
    }

    public static double wallSmoothing(Point2D.Double botLocation, double angle, double orientation) {
        while (!Module.bf.contains(DRUtils.project(botLocation, angle, 80.0))) {
            angle += orientation * 0.05;
        }
        return angle;
    }

    public static double[] getDCWave(Enemy e, BulletInfoEnemy b, HistoryLog myInfo, Module bot) {
        List<KdTree.Entry<HistoryLog>> list;
        if (!Module.melee && e.bulletHits1v1 < 1.0) {
            return BulletInfoEnemy.getDefaultWave();
        }
        if (Module.melee && e.bulletHitsMelee < 1.0) {
            return BulletInfoEnemy.getDefaultWave();
        }
        if (Module.melee) {
            if (e.enemyWaveTreeMelee.size() < 1) {
                return BulletInfoEnemy.getDefaultWave();
            }
            list = e.enemyWaveTreeMelee.nearestNeighbor(b.DCdistanceLocation, Math.min((int)Math.ceil(Math.sqrt(e.enemyWaveTreeMelee.size())), 25), false);
        } else {
            if (e.enemyWaveTree1vrs1.size() < 1) {
                return BulletInfoEnemy.getDefaultWave();
            }
            list = e.enemyWaveTree1vrs1.nearestNeighbor(b.DCdistanceLocation, Math.min((int)Math.ceil(Math.sqrt(e.enemyWaveTree1vrs1.size())), 25), true);
        }
        if (list.size() < 1) {
            System.out.println("null list");
            return BulletInfoEnemy.getDefaultWave();
        }
        double[] DCWave = BulletInfoEnemy.getZeroWave();
        double value = 0.04;
        long time = bot.getTime();
        int i = 0;
        while (i < list.size()) {
            Point2D.Double loc = BulletInfoEnemy.getWaveHitLocation((HistoryLog)list.get((int)i).value, e, b.velocity, time, bot);
            if (loc != null) {
                double index = BulletInfoEnemy.getBinIndex(b, loc);
                int x = 0;
                while (x < 41) {
                    double newEntry = 0.0;
                    if (Math.abs((double)x - index) < 4.0) {
                        newEntry = 1.0;
                    }
                    int n = x++;
                    DCWave[n] = DCWave[n] + newEntry * value;
                }
                int j = 1;
                while (j < 2) {
                    int x2 = 1;
                    while (x2 < 40) {
                        DCWave[x2] = DRUtils.rollingAverage(DCWave[x2], DCWave[x2 + 1], 2.0);
                        DCWave[40 - x2] = DRUtils.rollingAverage(DCWave[40 - x2], DCWave[40 - x2 - 1], 2.0);
                        ++x2;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return DCWave;
    }

    public static Point2D.Double getWaveHitLocation(HistoryLog similar, Enemy e, double bulletSpeed, long time, Module bot) {
        HistoryLog similarInfo = similar;
        HistoryLog currInfo = bot.myData.last;
        HistoryLog endInfo = similarInfo;
        long timeDelta = time - currInfo.scanTime;
        double predDist = 0.0;
        Point2D.Double myRelativePosition = DRUtils.project(similarInfo.location, Utils.normalRelativeAngle((double)(e.absBearingRadians + Math.PI - currInfo.headingRadians + similarInfo.headingRadians)), e.distance);
        while (endInfo.next != null && endInfo.round == similarInfo.round && endInfo.scanTime >= similarInfo.scanTime) {
            endInfo = endInfo.next;
            double bulletTime = myRelativePosition.distance(endInfo.location) / bulletSpeed + 1.0;
            if (Math.abs((double)(endInfo.scanTime - similarInfo.scanTime - timeDelta) - bulletTime) <= 1.0) break;
        }
        if (endInfo.next == null || endInfo.round != similarInfo.round) {
            return null;
        }
        double predAng = Utils.normalRelativeAngle((double)(DRUtils.absoluteBearing(similarInfo.location, endInfo.location) - similarInfo.headingRadians));
        predDist = similarInfo.location.distance(endInfo.location);
        Point2D.Double predLocation = DRUtils.project(currInfo.location, Utils.normalRelativeAngle((double)(predAng + currInfo.headingRadians)), predDist);
        if (!Module.bf.contains(predLocation)) {
            return null;
        }
        return predLocation;
    }
}

