/*
 * Decompiled with CFR 0.152.
 */
package lorneswork;

import java.awt.Color;
import java.awt.geom.Point2D;
import lorneswork.Enemy;
import robocode.AdvancedRobot;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Predator
extends AdvancedRobot {
    Enemy target;
    final double PI = Math.PI;
    int direction;
    double firePower;
    double bearingFromGun;
    double strafeOffset;

    public void run() {
        this.target = new Enemy();
        this.target.name = null;
        this.setColors(Color.green, Color.green, Color.green);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.doMovement();
            this.doFirePower();
            this.doScanner();
            this.doGun();
            if (this.target.name != null && Math.abs(this.bearingFromGun) < 0.10471975511965977 && this.getGunHeat() == 0.0) {
                if (this.getEnergy() > (double)3) {
                    this.fire(this.firePower);
                } else if (this.target.energy == 0.0) {
                    this.fire(0.1);
                }
            }
            this.execute();
        }
    }

    void doFirePower() {
        this.firePower = Math.min(400.0 / this.target.distance, (double)3);
    }

    void doMovement() {
        this.setMaxTurnRate(10.0);
        this.setMaxVelocity(8.0);
        if (this.getX() > this.getBattleFieldWidth() - 100.0 || this.getX() < 100.0 || this.getY() > this.getBattleFieldHeight() - 100.0 || this.getY() < 100.0) {
            double centerX = this.getBattleFieldWidth() / (double)2;
            double centerY = this.getBattleFieldHeight() / (double)2;
            double angleToCenter = this.NormalizeBearing(Math.atan2(this.getX() - centerX, this.getY() - centerX) - this.getHeadingRadians());
            this.setMaxVelocity(5);
            this.setTurnLeftRadians(angleToCenter);
            this.setAhead(50 * this.direction);
        } else if (this.target.name != null) {
            if (this.target.distance <= 200.0) {
                this.setTurnRightRadians(this.NormalizeBearing(this.target.bearing + 1.5707963267948966));
                double energyDelta = this.target.lastEnergy - this.target.energy;
                if (energyDelta <= (double)3 && energyDelta > 0.0) {
                    this.direction *= -1;
                }
                this.setAhead(this.direction * 100);
            } else {
                if (this.getTime() % 30L == 0L) {
                    this.strafeOffset *= -1.0;
                }
                this.setTurnRightRadians(this.NormalizeBearing(this.target.bearing + this.strafeOffset));
                this.setAhead(this.target.distance);
            }
        } else {
            this.setMaxVelocity(8.0);
            this.setMaxTurnRate(0.0);
            this.setAhead(this.direction * 100);
        }
    }

    void doScanner() {
        double radarOffset;
        radarOffset = this.getTime() - this.target.ctime > 6L || this.target.name == null ? 360.0 : ((radarOffset = this.NormalizeBearing(this.getRadarHeadingRadians() - this.absbearing(this.getX(), this.getY(), this.target.x, this.target.y))) < 0.0 ? (radarOffset -= 0.2617993877991494) : (radarOffset += 0.2617993877991494));
        this.setTurnRadarLeftRadians(this.NormalizeBearing(radarOffset));
    }

    void doGun() {
        double oldx;
        double w = -this.angle_180(this.target.head - this.target.lastHead);
        double absbearing = this.target.bearing + this.getHeadingRadians();
        double eX = this.target.x - this.getX();
        double eY = this.target.y - this.getY();
        double dx = this.target.speed * Math.sin(this.target.head);
        double dy = this.target.speed * Math.cos(this.target.head);
        double db = 0.0;
        do {
            oldx = dx;
        } while ((db += 20.0 - (double)3 * this.firePower) < Point2D.distance(0.0, 0.0, eX += (dx = Math.cos(w) * oldx - Math.sin(w) * dy), eY += (dy = Math.sin(w) * oldx + Math.cos(w) * dy)));
        this.bearingFromGun = this.angle_180(Math.atan2(eX, eY) - this.getGunHeadingRadians());
        this.target.lastHead = this.target.head;
        this.setTurnGunRightRadians(this.bearingFromGun);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (this.target.name == null) {
            this.target.name = e.getName();
            this.out.println("New target: " + this.target.name);
        }
        if (this.target.name == e.getName()) {
            double absbearing = (this.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
            this.target.name = e.getName();
            this.target.x = this.getX() + Math.sin(absbearing) * e.getDistance();
            this.target.y = this.getY() + Math.cos(absbearing) * e.getDistance();
            this.target.bearing = e.getBearingRadians();
            this.target.head = e.getHeadingRadians();
            this.target.ctime = this.getTime();
            this.target.speed = e.getVelocity();
            this.target.distance = e.getDistance();
            this.target.lastEnergy = this.target.energy;
            this.target.energy = e.getEnergy();
        }
    }

    public void onHitRobot(HitRobotEvent e) {
        if (this.target.name != e.getName()) {
            this.target.name = e.getName();
            this.out.println("New target due to collision: " + this.target.name);
        }
        if (e.isMyFault()) {
            this.direction *= -1;
        }
    }

    public void onHitWall(HitWallEvent e) {
        this.out.print("I hit a wall!\n");
        this.direction *= -1;
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (e.getName() == this.target.name) {
            this.out.println(this.target.name + " died. Finding new target...");
            this.target.name = null;
        }
    }

    public void onWin(WinEvent e) {
        this.out.print("I win!\n");
        this.setAhead(0.0);
        int i = 0;
        while (i < 50) {
            this.setColors(Color.green, Color.yellow, Color.green);
            this.turnRight(30.0);
            this.setColors(Color.yellow, Color.green, Color.yellow);
            this.turnLeft(30.0);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    double NormalizeBearing(double angle) {
        if (!(angle > -3.141592653589793) || !(angle <= 3.141592653589793)) ** GOTO lbl4
        return angle;
lbl-1000:
        // 1 sources

        {
            angle += 6.283185307179586;
lbl4:
            // 2 sources

            ** while (angle <= -3.141592653589793)
        }
lbl5:
        // 2 sources

        while (angle > 3.141592653589793) {
            angle -= 6.283185307179586;
        }
        return angle;
    }

    public double angle_180(double angle) {
        return Math.atan2(Math.sin(angle), Math.cos(angle));
    }

    public double getrange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    public double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = this.getrange(x1, y1, x2, y2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }

    private final /* synthetic */ void this() {
        this.PI = Math.PI;
        this.direction = 1;
        this.strafeOffset = 0.7853981633974483;
    }

    public Predator() {
        this.this();
    }
}

