/*
 * Decompiled with CFR 0.152.
 */
package cbot.cbot;

import cbot.cbot.Bot;
import cbot.cbot.CU;
import cbot.cbot.Point;
import cbot.cbot.Pray;
import cbot.cbot.PrayManager;
import cbot.cbot.driver.AntiGravityDriver;
import cbot.cbot.gun.Gun;
import cbot.cbot.gun.Pattern;
import cbot.cbot.gun.VirtualBullet;
import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RadarTurnCompleteCondition;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class CBot
extends AdvancedRobot
implements Bot {
    public static PrayManager prayManager;
    public static Gun gun;
    private static int win;
    private static int lost;
    private static int skippedTurns;
    private static int totalTurns;
    public AntiGravityDriver driver;
    private Pattern pattern;
    private Pray currentPray;
    private Point currentCordinate;

    public void run() {
        this.initRobot();
        while (true) {
            this.initTurn();
            if (this.currentPray != null) {
                gun.aimAndFire(this.currentPray);
                this.driver.drive(this.currentPray);
            }
            this.execute();
        }
    }

    private final void initTurn() {
        ++totalTurns;
        this.currentPray = prayManager.getPray();
        this.currentCordinate = new Point(this.getX(), this.getY());
        if (this.currentPray == null) {
            this.setTurnRadarRight(360.0);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        boolean bl = false;
        if (prayManager.getNumberOfPray() == 0) {
            bl = true;
        }
        boolean zeroPray = bl;
        this.currentPray = prayManager.add(e);
        if (!zeroPray) {
            if (this.currentPray.getName().equals(e.getName())) {
                gun.aim(this.currentPray);
            }
            if (this.getOthers() == 1) {
                this.setTurnRadarRight(CU.normalRelativeAngle(this.getHeading() + this.currentPray.getBearing() - this.getRadarHeading()) * 1.6);
            }
        }
    }

    public void onWin(WinEvent e) {
        ++win;
        this.end();
        this.driver.victoryDance();
    }

    public void onDeath(DeathEvent e) {
        ++lost;
        this.end();
    }

    public void onBulletHit(BulletHitEvent e) {
        Pray pray = prayManager.getPray(e.getName());
        if (pray != null) {
            pray.gotHitByBullet(e.getBullet());
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.driver.handleBeeingHit();
        Pray pray = prayManager.getPray(e.getName());
        if (pray != null) {
            pray.hitRobotWithBullet(e.getBullet());
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        prayManager.remove(e.getName());
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        ++skippedTurns;
        CU.log("\n*** Warning! Skipped event! ***\n");
    }

    public void onHitWall(HitWallEvent e) {
        this.driver.handleHitWall(e.getBearing());
    }

    public void onHitRobot(HitRobotEvent e) {
        this.driver.handleCollision(e);
    }

    public void onCustomEvent(CustomEvent e) {
        if (e.getCondition() instanceof RadarTurnCompleteCondition && this.getOthers() > 1) {
            double angle = prayManager.getRadarTurningAngle();
            this.setTurnRadarRight(angle);
        }
        if (e.getCondition() instanceof VirtualBullet) {
            ((VirtualBullet)e.getCondition()).updateHittingRates();
            this.removeCustomEvent(e.getCondition());
        }
    }

    public Point getCordinate() {
        return this.currentCordinate;
    }

    public double getFirePower(Bot bot) {
        return CU.getFirePower(bot);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public double getDistance() {
        return this.currentPray.getDistance();
    }

    public double getBearing() {
        return 10000.0;
    }

    private final void initRobot() {
        this.setColors(new Color(0, 102, 0), new Color(204, 255, 204), new Color(204, 255, 204));
        CU.init(this);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        prayManager = new PrayManager(this);
        this.driver = new AntiGravityDriver(this);
        if (this.getOthers() > 1) {
            this.addCustomEvent((Condition)new RadarTurnCompleteCondition((AdvancedRobot)this));
        } else {
            this.setTurnRadarRight(360.0);
        }
        if (this.pattern == null) {
            this.pattern = new Pattern();
        }
        if (gun == null) {
            gun = new Gun(this);
        } else {
            gun.update(this);
        }
    }

    private final void printStatistics() {
        prayManager.clear();
        String str = "";
        str = str + gun.getHittingRate() + '\n';
        str = str + this.currentPray.getHittingRates();
        double[] prayRate = this.currentPray.getDistanceHittingRates();
        double[] roboRate = gun.getDistanceHittingRates();
        str = str + "HR diff S=" + CU.formatNumber(roboRate[0] / prayRate[0]) + " M=" + CU.formatNumber(roboRate[1] / prayRate[1]) + " L=" + CU.formatNumber(roboRate[2] / prayRate[2]);
        str = str + "Avg pattern: " + this.currentPray.getPattern().getAvgPatternLength();
        str = str + "score: [" + win + '-' + lost + "] skipp: " + CU.formatNumber((double)skippedTurns / (double)totalTurns, 4);
        CU.log(str);
    }

    private final void end() {
        this.clearAllEvents();
        this.printStatistics();
        prayManager.clear();
    }

    static {
        win = 0;
        lost = 0;
        skippedTurns = 0;
        totalTurns = 0;
    }
}

