/*
 * Decompiled with CFR 0.152.
 */
package cbot.cbot.driver;

import cbot.cbot.CU;
import cbot.cbot.Point;
import cbot.cbot.Pray;
import robocode.AdvancedRobot;
import robocode.HitRobotEvent;

public abstract class AbstractDriver {
    protected final AdvancedRobot robot;
    protected Pray currentPray;
    private int drivingDirection = 1;

    public AbstractDriver(AdvancedRobot advancedRobot) {
        this.robot = advancedRobot;
    }

    public void drive(Pray pray) {
        this.currentPray = pray;
    }

    public void victoryDance() {
        this.robot.setStop();
        this.robot.setTurnGunRight(360.0);
    }

    public void handleBeeingHit() {
    }

    public void handleHitWall(double d) {
    }

    public void handleCollision(HitRobotEvent hitRobotEvent) {
    }

    public void handleBeingFiredAt(Pray pray, double d, double d2) {
    }

    protected void steerRight(double d) {
        if (d > 90.0) {
            d -= 180.0;
            this.drivingDirection = -1;
        } else if (d < -90.0) {
            d += 180.0;
            this.drivingDirection = -1;
        } else {
            this.drivingDirection = 1;
        }
        this.robot.setTurnRight(d);
    }

    protected void forward(double d) {
        this.robot.setAhead((double)this.drivingDirection * d);
    }

    protected double getRealHeading() {
        double d = this.robot.getHeading();
        if (this.drivingDirection == -1) {
            d = CU.normalRelativeAngle(d + 180.0);
        }
        if (d < 0.0) {
            d = 360.0 + d;
        }
        return d;
    }

    protected double getParallelAngle() {
        if (this.currentPray == null) {
            return 0.0;
        }
        return CU.normalRelativeAngle(this.currentPray.getBearing() + 90.0);
    }

    protected double getGoToAngle(Point point) {
        return Math.toDegrees(this.getRoboCord().getAngle(point)) - this.robot.getHeading();
    }

    protected double turnToAvoideWall(int n) {
        int n2 = CU.getCloseWalls(this.getRoboCord(), n)[0];
        if (n2 == -1) {
            return 0.0;
        }
        double d = this.getRealHeading();
        double d2 = 0.0;
        if (n2 == 4 && d < 270.0 && d > 180.0) {
            d2 = 180.0 - d;
        }
        if (n2 == 4 && d > 270.0 && d < 360.0) {
            d2 = 360.0 - d;
        }
        if (n2 == 3 && d < 180.0 && d > 90.0) {
            d2 = 90.0 - d;
        }
        if (n2 == 3 && d > 180.0 && d < 270.0) {
            d2 = 270.0 - d;
        }
        if (n2 == 2 && d < 90.0 && d > 0.0) {
            d2 = 0.0 - d;
        }
        if (n2 == 2 && d > 90.0 && d < 180.0) {
            d2 = 180.0 - d;
        }
        if (n2 == 1 && d < 360.0 && d > 270.0) {
            d2 = 270.0 - d;
        }
        if (n2 == 1 && d > 0.0 && d < 90.0) {
            d2 = 90.0 - d;
        }
        if (d2 > 45.0) {
            this.robot.setMaxVelocity(0.0);
        }
        this.robot.setTurnRight(d2);
        return d2;
    }

    protected Point getRoboCord() {
        return new Point(this.robot.getX(), this.robot.getY());
    }
}

