/*
 * Decompiled with CFR 0.152.
 */
package de._4geeks.robots.guns;

import de._4geeks.robots.guns.Gun;
import de._4geeks.robots.guns.LGun;
import de._4geeks.robots.guns.VCSResearch;
import de._4geeks.robots.guns.VGun;
import de._4geeks.robots.guns.manager.EnemyScan;
import de._4geeks.robots.guns.manager.GunAimedEvent;
import de._4geeks.robots.guns.manager.GunCoolEvent;
import de._4geeks.robots.guns.manager.Wave;
import de._4geeks.robots.utils.SUtils;
import java.awt.Graphics2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class GunManager
implements Gun {
    private AdvancedRobot robot;
    private EnemyScan enemy;
    GunState gunState = GunState.FIRED;
    ArrayList<Wave> finishedWaves = new ArrayList();
    ArrayList<Wave> runningWaves = new ArrayList();
    ArrayList<VGun> guns = new ArrayList();
    ArrayList<LGun> learnFiring = new ArrayList();
    ArrayList<LGun> learnAll = new ArrayList();
    public int selectedGun = 0;
    private Wave currentWave;
    private Wave aimedWave;
    private double aimedFirepower;
    private Bullet bullet;
    private int hits = 0;
    private boolean firedOnce;
    private boolean isTC;

    public GunManager(AdvancedRobot robot, boolean isTC) {
        this.robot = robot;
        this.isTC = isTC;
        robot.addCustomEvent((Condition)new GunCoolEvent(robot, this));
        this.learnAll.add(new VCSResearch(robot, this));
        this.initLGuns();
        VGun.createStats(this.guns);
        this.firedOnce = false;
    }

    public void initLGuns() {
        for (LGun gun : this.learnFiring) {
            if (!gun.receiveAllWaves()) continue;
            this.learnAll.add(gun);
        }
    }

    public int addVGun(VGun gun) {
        this.guns.add(gun);
        return this.guns.size() - 1;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (this.enemy == null) {
            this.enemy = new EnemyScan(this.robot, e.getName());
        }
        this.enemy.getName();
        e.getName();
        this.enemy.update(e);
    }

    public void setGunAimed() {
        this.gunState = GunState.AIMED;
    }

    public void setGunCooled() {
        this.gunState = GunState.COOL;
    }

    public void registerWave(Wave wave) {
        this.finishedWaves.add(wave);
    }

    public EnemyScan getEnemy() {
        return this.enemy;
    }

    public void doGun() {
        if (this.enemy != null && this.robot.getEnergy() > 0.0) {
            this.doLearning();
            if (this.currentWave != null && this.learnAll.size() > 0 && this.firedOnce) {
                this.currentWave.fire();
                this.runningWaves.add(this.currentWave);
                this.currentWave = null;
            }
            try {
                this.aimedFirepower = this.selectFirepower();
                this.currentWave = new Wave(this.robot, this, this.enemy.clone(), this.aimedFirepower);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                return;
            }
            if (this.gunState == GunState.COOL) {
                this.aimGun();
            } else if (this.gunState == GunState.AIMED) {
                this.fireGun();
            }
        }
    }

    private void doLearning() {
        if (this.enemy == null) {
            return;
        }
        for (Wave wave : this.finishedWaves) {
            if (wave.isFiringWave()) {
                int i = 0;
                while (i < this.guns.size()) {
                    this.guns.get(i).addError(wave, wave.getGuess(i));
                    ++i;
                }
                for (LGun gun : this.learnFiring) {
                    gun.doLearning(wave);
                }
            }
            for (LGun gun : this.learnAll) {
                gun.doLearning(wave);
            }
        }
        this.finishedWaves.clear();
    }

    private void aimGun() {
        if (this.enemy == null) {
            return;
        }
        VGun bestGun = this.getBestGun();
        double guessFactor = 0.0;
        if (bestGun != null) {
            guessFactor = this.currentWave.getGuess(this.guns.indexOf(bestGun));
            bestGun.fire();
        }
        double forwardMEA = this.currentWave.getForwardMaxEscapeAngle();
        double reverseMEA = this.currentWave.getReverseMaxEscapeAngle();
        double mea = guessFactor > 0.0 ? Math.abs(forwardMEA) : Math.abs(reverseMEA);
        double g = guessFactor * mea * SUtils.sign(this.currentWave.getEnemy().getAngularVelocity());
        double gunOffset = Utils.normalRelativeAngle((double)(this.robot.getGunHeadingRadians() - this.currentWave.getEnemy().getAbsoluteBearing() - g));
        this.robot.setTurnGunLeftRadians(gunOffset);
        this.robot.addCustomEvent((Condition)new GunAimedEvent(this.robot, this));
        this.gunState = GunState.AIMING;
        this.aimedWave = this.currentWave;
        this.currentWave = null;
    }

    private VGun getBestGun() {
        double bestError = Double.MAX_VALUE;
        VGun bestGun = null;
        for (VGun gun : this.guns) {
            this.currentWave.addGuess(gun.doAim(this.currentWave));
            if (!(gun.getError() < bestError)) continue;
            bestError = gun.getError();
            bestGun = gun;
        }
        return bestGun;
    }

    private void fireGun() {
        this.bullet = this.robot.setFireBullet(this.aimedWave.getFirePower());
        if (this.bullet != null) {
            this.gunState = GunState.FIRED;
            this.robot.addCustomEvent((Condition)new GunCoolEvent(this.robot, this));
            this.aimedWave.fire(this.bullet);
            this.runningWaves.add(this.aimedWave);
            this.aimedWave = null;
            this.firedOnce = true;
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        ++this.hits;
        for (Wave wave : this.runningWaves) {
            wave.bulletHitTest(e.getBullet());
        }
        for (Wave wave : this.finishedWaves) {
            wave.bulletHitTest(e.getBullet());
        }
    }

    private double selectFirepower() {
        if (this.isTC) {
            return 3.0;
        }
        double selectFP = 1.9;
        if (this.enemy.getDistance() < 80.0) {
            selectFP = 3.0;
        }
        return Math.min(this.robot.getEnergy() - 0.1, selectFP);
    }

    public AdvancedRobot getRobot() {
        return this.robot;
    }

    public void onPaint(Graphics2D g) {
        for (Wave w : this.runningWaves) {
            w.onPaint(g);
        }
        for (LGun gun : this.learnAll) {
            gun.onPaint(g);
        }
        for (LGun gun : this.learnFiring) {
            gun.onPaint(g);
        }
    }

    public void battleOver() {
        VGun.roundOver(this.guns);
        VGun.battleOver(this.robot, this.enemy.getName());
        for (LGun gun : this.learnFiring) {
            gun.battleOver();
        }
    }

    public void roundOver() {
        VGun.roundOver(this.guns);
        for (LGun gun : this.learnFiring) {
            gun.roundOver();
        }
    }

    public Wave getCurrentWave() {
        return this.currentWave;
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (this.enemy != null && this.enemy.getName() == e.getName()) {
            this.enemy = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GunState {
        COOL,
        AIMING,
        AIMED,
        FIRED;

    }
}

