/*
 * Decompiled with CFR 0.152.
 */
package de._4geeks.robots.utils;

import de._4geeks.robots.guns.manager.Wave;

public class GuessFactorWindow {
    double angle;
    double min;
    double max;

    public GuessFactorWindow(Wave wave) {
        this.angle = Math.atan2(18.0, wave.getEnemy().getDistance());
        double forwardMEA = wave.getForwardMaxEscapeAngle();
        double reverseMEA = wave.getReverseMaxEscapeAngle();
        if (wave.getGuessFactor() < 0.0) {
            this.min = wave.getGuessFactor() - Math.abs(this.angle / reverseMEA);
            this.max = wave.getGuessFactor() + Math.abs(this.angle / reverseMEA);
        } else {
            this.min = wave.getGuessFactor() - Math.abs(this.angle / forwardMEA);
            this.max = wave.getGuessFactor() + Math.abs(this.angle / forwardMEA);
        }
    }

    public GuessFactorWindow(double gf, double distance, double mea) {
        this.angle = Math.atan2(19.0, distance);
        this.min = gf - Math.abs(this.angle / mea);
        this.max = gf + Math.abs(this.angle / mea);
    }

    public boolean isIn(int b, int bins) {
        int minBin = (int)(this.min * (double)(bins / 2)) + bins / 2;
        int maxBin = (int)(this.max * (double)(bins / 2)) + bins / 2;
        return minBin <= b && b <= maxBin;
    }

    public double getFactor(int b, int bins) {
        int minBin = (int)(this.min * (double)(bins / 2)) + bins / 2;
        int maxBin = (int)(this.max * (double)(bins / 2)) + bins / 2;
        double delta = (double)(maxBin - minBin + 2) / 2.0;
        if (b >= minBin && (double)b < (double)minBin + delta - 1.0) {
            return (double)(b - minBin + 1) / delta;
        }
        if ((double)b >= (double)minBin + delta - 1.0 && b <= maxBin) {
            return (double)(maxBin - b + 1) / delta;
        }
        return 0.0;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }
}

